/* DrawingArea.c generated by valac 0.56.18, the Vala compiler
 * generated from DrawingArea.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-2.0-or-later
 * SPDX-FileCopyrightText: 2019-2024 elementary, Inc. (https://elementary.io)
 */

#include "wacom.h"
#include <cairo-gobject.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	WACOM_WIDGETS_DRAWING_AREA_0_PROPERTY,
	WACOM_WIDGETS_DRAWING_AREA_NUM_PROPERTIES
};
static GParamSpec* wacom_widgets_drawing_area_properties[WACOM_WIDGETS_DRAWING_AREA_NUM_PROPERTIES];
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _WacomWidgetsDrawingAreaPrivate {
	cairo_surface_t* surface;
	cairo_t* cr;
	GtkGestureStylus* stylus_gesture;
};

static gint WacomWidgetsDrawingArea_private_offset;
static gpointer wacom_widgets_drawing_area_parent_class = NULL;

static void wacom_widgets_drawing_area_real_size_allocate (GtkWidget* base,
                                                    gint width,
                                                    gint height,
                                                    gint baseline);
static void wacom_widgets_drawing_area_ensure_drawing_surface (WacomWidgetsDrawingArea* self,
                                                        gint width,
                                                        gint height,
                                                        gboolean force);
static void wacom_widgets_drawing_area_real_map (GtkWidget* base);
static void wacom_widgets_drawing_area_draw_func (WacomWidgetsDrawingArea* self,
                                           GtkDrawingArea* drawing_area,
                                           cairo_t* cr,
                                           gint width,
                                           gint height);
static void _wacom_widgets_drawing_area_draw_func_gtk_drawing_area_draw_func (GtkDrawingArea* drawing_area,
                                                                       cairo_t* cr,
                                                                       gint width,
                                                                       gint height,
                                                                       gpointer self);
static void wacom_widgets_drawing_area_on_motion (WacomWidgetsDrawingArea* self,
                                           gdouble x,
                                           gdouble y);
static void wacom_widgets_drawing_area_on_up (WacomWidgetsDrawingArea* self,
                                       gdouble x,
                                       gdouble y);
static GObject * wacom_widgets_drawing_area_constructor (GType type,
                                                  guint n_construct_properties,
                                                  GObjectConstructParam * construct_properties);
static void _wacom_widgets_drawing_area_on_up_gtk_gesture_stylus_up (GtkGestureStylus* _sender,
                                                              gdouble x,
                                                              gdouble y,
                                                              gpointer self);
static void _wacom_widgets_drawing_area_on_motion_gtk_gesture_stylus_motion (GtkGestureStylus* _sender,
                                                                      gdouble x,
                                                                      gdouble y,
                                                                      gpointer self);
static void wacom_widgets_drawing_area_finalize (GObject * obj);
static GType wacom_widgets_drawing_area_get_type_once (void);

static inline gpointer
wacom_widgets_drawing_area_get_instance_private (WacomWidgetsDrawingArea* self)
{
	return G_STRUCT_MEMBER_P (self, WacomWidgetsDrawingArea_private_offset);
}

static void
wacom_widgets_drawing_area_real_size_allocate (GtkWidget* base,
                                               gint width,
                                               gint height,
                                               gint baseline)
{
	WacomWidgetsDrawingArea * self;
	self = (WacomWidgetsDrawingArea*) base;
	wacom_widgets_drawing_area_ensure_drawing_surface (self, width, height, FALSE);
	GTK_WIDGET_CLASS (wacom_widgets_drawing_area_parent_class)->size_allocate ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_drawing_area_get_type (), GtkDrawingArea), width, height, baseline);
}

static void
_wacom_widgets_drawing_area_draw_func_gtk_drawing_area_draw_func (GtkDrawingArea* drawing_area,
                                                                  cairo_t* cr,
                                                                  gint width,
                                                                  gint height,
                                                                  gpointer self)
{
	wacom_widgets_drawing_area_draw_func ((WacomWidgetsDrawingArea*) self, drawing_area, cr, width, height);
}

static void
wacom_widgets_drawing_area_real_map (GtkWidget* base)
{
	WacomWidgetsDrawingArea * self;
	self = (WacomWidgetsDrawingArea*) base;
	GTK_WIDGET_CLASS (wacom_widgets_drawing_area_parent_class)->map ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_drawing_area_get_type (), GtkDrawingArea));
	wacom_widgets_drawing_area_ensure_drawing_surface (self, gtk_widget_get_width ((GtkWidget*) self), gtk_widget_get_height ((GtkWidget*) self), FALSE);
	gtk_drawing_area_set_draw_func ((GtkDrawingArea*) self, _wacom_widgets_drawing_area_draw_func_gtk_drawing_area_draw_func, g_object_ref (self), g_object_unref);
}

void
wacom_widgets_drawing_area_clear (WacomWidgetsDrawingArea* self)
{
	g_return_if_fail (self != NULL);
	wacom_widgets_drawing_area_ensure_drawing_surface (self, gtk_widget_get_width ((GtkWidget*) self), gtk_widget_get_height ((GtkWidget*) self), TRUE);
}

static gpointer
_cairo_surface_reference0 (gpointer self)
{
	return self ? cairo_surface_reference (self) : NULL;
}

static void
wacom_widgets_drawing_area_ensure_drawing_surface (WacomWidgetsDrawingArea* self,
                                                   gint width,
                                                   gint height,
                                                   gboolean force)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	cairo_surface_t* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp3_ = self->priv->surface;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		cairo_surface_t* _tmp4_;
		_tmp4_ = self->priv->surface;
		_tmp2_ = cairo_image_surface_get_width (_tmp4_) != width;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		cairo_surface_t* _tmp5_;
		_tmp5_ = self->priv->surface;
		_tmp1_ = cairo_image_surface_get_height (_tmp5_) != height;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = force;
	}
	if (_tmp0_) {
		cairo_surface_t* new_surface = NULL;
		cairo_surface_t* _tmp6_;
		gboolean _tmp7_ = FALSE;
		cairo_surface_t* _tmp8_;
		cairo_surface_t* _tmp14_;
		cairo_surface_t* _tmp15_;
		cairo_surface_t* _tmp16_;
		cairo_t* _tmp17_;
		_tmp6_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, width, height);
		new_surface = _tmp6_;
		_tmp8_ = self->priv->surface;
		if (_tmp8_ != NULL) {
			_tmp7_ = !force;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			cairo_t* cr = NULL;
			cairo_surface_t* _tmp9_;
			cairo_t* _tmp10_;
			cairo_t* _tmp11_;
			cairo_surface_t* _tmp12_;
			cairo_t* _tmp13_;
			_tmp9_ = new_surface;
			_tmp10_ = cairo_create (_tmp9_);
			cr = _tmp10_;
			_tmp11_ = cr;
			_tmp12_ = self->priv->surface;
			cairo_set_source_surface (_tmp11_, _tmp12_, (gdouble) 0, (gdouble) 0);
			_tmp13_ = cr;
			cairo_paint (_tmp13_);
			_cairo_destroy0 (cr);
		}
		_tmp14_ = new_surface;
		_tmp15_ = _cairo_surface_reference0 (_tmp14_);
		_cairo_surface_destroy0 (self->priv->surface);
		self->priv->surface = _tmp15_;
		_tmp16_ = self->priv->surface;
		_tmp17_ = cairo_create (_tmp16_);
		_cairo_destroy0 (self->priv->cr);
		self->priv->cr = _tmp17_;
		_cairo_surface_destroy0 (new_surface);
	}
}

static void
wacom_widgets_drawing_area_draw_func (WacomWidgetsDrawingArea* self,
                                      GtkDrawingArea* drawing_area,
                                      cairo_t* cr,
                                      gint width,
                                      gint height)
{
	cairo_surface_t* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (drawing_area != NULL);
	g_return_if_fail (cr != NULL);
	cairo_set_source_rgb (cr, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	cairo_paint (cr);
	_tmp0_ = self->priv->surface;
	cairo_set_source_surface (cr, _tmp0_, (gdouble) 0, (gdouble) 0);
	cairo_paint (cr);
}

static void
wacom_widgets_drawing_area_on_motion (WacomWidgetsDrawingArea* self,
                                      gdouble x,
                                      gdouble y)
{
	gdouble pressure = 0.0;
	GtkGestureStylus* _tmp0_;
	gdouble _tmp1_ = 0.0;
	GdkDeviceToolType tool_type = 0;
	GtkGestureStylus* _tmp2_;
	GdkDeviceTool* _tmp3_;
	cairo_t* _tmp8_;
	cairo_t* _tmp9_;
	cairo_t* _tmp10_;
	cairo_t* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stylus_gesture;
	gtk_gesture_stylus_get_axis (_tmp0_, GDK_AXIS_PRESSURE, &_tmp1_);
	pressure = _tmp1_;
	_tmp2_ = self->priv->stylus_gesture;
	_tmp3_ = gtk_gesture_stylus_get_device_tool (_tmp2_);
	tool_type = gdk_device_tool_get_tool_type (_tmp3_);
	if (tool_type == GDK_DEVICE_TOOL_TYPE_ERASER) {
		cairo_t* _tmp4_;
		cairo_t* _tmp5_;
		_tmp4_ = self->priv->cr;
		cairo_set_line_width (_tmp4_, 10 * pressure);
		_tmp5_ = self->priv->cr;
		cairo_set_operator (_tmp5_, CAIRO_OPERATOR_DEST_OUT);
	} else {
		cairo_t* _tmp6_;
		cairo_t* _tmp7_;
		_tmp6_ = self->priv->cr;
		cairo_set_line_width (_tmp6_, 4 * pressure);
		_tmp7_ = self->priv->cr;
		cairo_set_operator (_tmp7_, CAIRO_OPERATOR_SATURATE);
	}
	_tmp8_ = self->priv->cr;
	cairo_set_source_rgba (_tmp8_, (gdouble) 0, (gdouble) 0, (gdouble) 0, pressure);
	_tmp9_ = self->priv->cr;
	cairo_line_to (_tmp9_, x, y);
	_tmp10_ = self->priv->cr;
	cairo_stroke (_tmp10_);
	_tmp11_ = self->priv->cr;
	cairo_move_to (_tmp11_, x, y);
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static void
wacom_widgets_drawing_area_on_up (WacomWidgetsDrawingArea* self,
                                  gdouble x,
                                  gdouble y)
{
	cairo_t* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->cr;
	cairo_new_path (_tmp0_);
}

WacomWidgetsDrawingArea*
wacom_widgets_drawing_area_construct (GType object_type)
{
	WacomWidgetsDrawingArea * self = NULL;
	self = (WacomWidgetsDrawingArea*) g_object_new (object_type, NULL);
	return self;
}

WacomWidgetsDrawingArea*
wacom_widgets_drawing_area_new (void)
{
	return wacom_widgets_drawing_area_construct (WACOM_WIDGETS_TYPE_DRAWING_AREA);
}

static void
_wacom_widgets_drawing_area_on_up_gtk_gesture_stylus_up (GtkGestureStylus* _sender,
                                                         gdouble x,
                                                         gdouble y,
                                                         gpointer self)
{
	wacom_widgets_drawing_area_on_up ((WacomWidgetsDrawingArea*) self, x, y);
}

static void
_wacom_widgets_drawing_area_on_motion_gtk_gesture_stylus_motion (GtkGestureStylus* _sender,
                                                                 gdouble x,
                                                                 gdouble y,
                                                                 gpointer self)
{
	wacom_widgets_drawing_area_on_motion ((WacomWidgetsDrawingArea*) self, x, y);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GObject *
wacom_widgets_drawing_area_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	WacomWidgetsDrawingArea * self;
	GtkGestureStylus* _tmp0_;
	GtkGestureStylus* _tmp1_;
	GtkGestureStylus* _tmp2_;
	GtkGestureStylus* _tmp3_;
	GtkEventController* _tmp4_;
	parent_class = G_OBJECT_CLASS (wacom_widgets_drawing_area_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WACOM_WIDGETS_TYPE_DRAWING_AREA, WacomWidgetsDrawingArea);
	_tmp0_ = (GtkGestureStylus*) gtk_gesture_stylus_new ();
	_g_object_unref0 (self->priv->stylus_gesture);
	self->priv->stylus_gesture = _tmp0_;
	_tmp1_ = self->priv->stylus_gesture;
	g_signal_connect_object (_tmp1_, "up", (GCallback) _wacom_widgets_drawing_area_on_up_gtk_gesture_stylus_up, self, 0);
	_tmp2_ = self->priv->stylus_gesture;
	g_signal_connect_object (_tmp2_, "motion", (GCallback) _wacom_widgets_drawing_area_on_motion_gtk_gesture_stylus_motion, self, 0);
	_tmp3_ = self->priv->stylus_gesture;
	_tmp4_ = _g_object_ref0 ((GtkEventController*) _tmp3_);
	gtk_widget_add_controller ((GtkWidget*) self, _tmp4_);
	return obj;
}

static void
wacom_widgets_drawing_area_class_init (WacomWidgetsDrawingAreaClass * klass,
                                       gpointer klass_data)
{
	wacom_widgets_drawing_area_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &WacomWidgetsDrawingArea_private_offset);
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget*, gint, gint, gint)) wacom_widgets_drawing_area_real_size_allocate;
	((GtkWidgetClass *) klass)->map = (void (*) (GtkWidget*)) wacom_widgets_drawing_area_real_map;
	G_OBJECT_CLASS (klass)->constructor = wacom_widgets_drawing_area_constructor;
	G_OBJECT_CLASS (klass)->finalize = wacom_widgets_drawing_area_finalize;
}

static void
wacom_widgets_drawing_area_instance_init (WacomWidgetsDrawingArea * self,
                                          gpointer klass)
{
	self->priv = wacom_widgets_drawing_area_get_instance_private (self);
	self->priv->surface = NULL;
	self->priv->cr = NULL;
}

static void
wacom_widgets_drawing_area_finalize (GObject * obj)
{
	WacomWidgetsDrawingArea * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WACOM_WIDGETS_TYPE_DRAWING_AREA, WacomWidgetsDrawingArea);
	_cairo_surface_destroy0 (self->priv->surface);
	_cairo_destroy0 (self->priv->cr);
	_g_object_unref0 (self->priv->stylus_gesture);
	G_OBJECT_CLASS (wacom_widgets_drawing_area_parent_class)->finalize (obj);
}

static GType
wacom_widgets_drawing_area_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WacomWidgetsDrawingAreaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) wacom_widgets_drawing_area_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WacomWidgetsDrawingArea), 0, (GInstanceInitFunc) wacom_widgets_drawing_area_instance_init, NULL };
	GType wacom_widgets_drawing_area_type_id;
	wacom_widgets_drawing_area_type_id = g_type_register_static (gtk_drawing_area_get_type (), "WacomWidgetsDrawingArea", &g_define_type_info, 0);
	WacomWidgetsDrawingArea_private_offset = g_type_add_instance_private (wacom_widgets_drawing_area_type_id, sizeof (WacomWidgetsDrawingAreaPrivate));
	return wacom_widgets_drawing_area_type_id;
}

GType
wacom_widgets_drawing_area_get_type (void)
{
	static volatile gsize wacom_widgets_drawing_area_type_id__once = 0;
	if (g_once_init_enter (&wacom_widgets_drawing_area_type_id__once)) {
		GType wacom_widgets_drawing_area_type_id;
		wacom_widgets_drawing_area_type_id = wacom_widgets_drawing_area_get_type_once ();
		g_once_init_leave (&wacom_widgets_drawing_area_type_id__once, wacom_widgets_drawing_area_type_id);
	}
	return wacom_widgets_drawing_area_type_id__once;
}

