/* RsyncSpaceCheckTask.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from RsyncSpaceCheckTask.vala, do not modify */

/*
 * RsyncTask.vala
 *
 * Copyright 2012-2018 Tony George <teejeetech@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 *
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ASYNC_TASK (async_task_get_type ())
#define ASYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASYNC_TASK, AsyncTask))
#define ASYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASYNC_TASK, AsyncTaskClass))
#define IS_ASYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASYNC_TASK))
#define IS_ASYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASYNC_TASK))
#define ASYNC_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASYNC_TASK, AsyncTaskClass))

typedef struct _AsyncTask AsyncTask;
typedef struct _AsyncTaskClass AsyncTaskClass;
typedef struct _AsyncTaskPrivate AsyncTaskPrivate;
typedef enum  {
	APP_STATUS_NOT_STARTED,
	APP_STATUS_RUNNING,
	APP_STATUS_PAUSED,
	APP_STATUS_FINISHED,
	APP_STATUS_CANCELLED,
	APP_STATUS_PASSWORD_REQUIRED
} AppStatus;

#define TYPE_APP_STATUS (app_status_get_type ())

#define TYPE_RSYNC_SPACE_CHECK_TASK (rsync_space_check_task_get_type ())
#define RSYNC_SPACE_CHECK_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTask))
#define RSYNC_SPACE_CHECK_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTaskClass))
#define IS_RSYNC_SPACE_CHECK_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RSYNC_SPACE_CHECK_TASK))
#define IS_RSYNC_SPACE_CHECK_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RSYNC_SPACE_CHECK_TASK))
#define RSYNC_SPACE_CHECK_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTaskClass))

typedef struct _RsyncSpaceCheckTask RsyncSpaceCheckTask;
typedef struct _RsyncSpaceCheckTaskClass RsyncSpaceCheckTaskClass;
typedef struct _RsyncSpaceCheckTaskPrivate RsyncSpaceCheckTaskPrivate;
enum  {
	RSYNC_SPACE_CHECK_TASK_0_PROPERTY,
	RSYNC_SPACE_CHECK_TASK_NUM_PROPERTIES
};
static GParamSpec* rsync_space_check_task_properties[RSYNC_SPACE_CHECK_TASK_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _AsyncTask {
	GObject parent_instance;
	AsyncTaskPrivate * priv;
	GDataOutputStream* dos_log;
	gboolean is_terminated;
	GPid child_pid;
	gchar* script_file;
	gchar* working_dir;
	gchar* log_file;
	gboolean background_mode;
	AppStatus status;
	GMutex status_line_mutex;
	gint exit_code;
	gchar* error_msg;
	GTimer* timer;
	gdouble progress;
	gdouble percent;
	gint64 prg_count;
	gint64 prg_count_total;
	gint64 prg_bytes;
	gint64 prg_bytes_total;
	gchar* eta;
};

struct _AsyncTaskClass {
	GObjectClass parent_class;
	void (*parse_stdout_line) (AsyncTask* self, const gchar* out_line);
	void (*parse_stderr_line) (AsyncTask* self, const gchar* err_line);
	void (*finish_task) (AsyncTask* self);
};

struct _RsyncSpaceCheckTask {
	AsyncTask parent_instance;
	RsyncSpaceCheckTaskPrivate * priv;
	gboolean delete_extra;
	gboolean delete_after;
	gboolean delete_excluded;
	gboolean relative;
	gchar* exclude_from_file;
	gchar* link_from_path;
	gchar* source_path;
	gchar* dest_path;
	gboolean verbose;
	gboolean io_nice;
	gboolean dry_run;
	gint64 status_line_count;
	gint64 total_size;
};

struct _RsyncSpaceCheckTaskClass {
	AsyncTaskClass parent_class;
};

struct _RsyncSpaceCheckTaskPrivate {
	GRegex* sent_bytes_regex;
};

static gint RsyncSpaceCheckTask_private_offset;
static gpointer rsync_space_check_task_parent_class = NULL;

VALA_EXTERN GType async_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AsyncTask, g_object_unref)
VALA_EXTERN GType app_status_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType rsync_space_check_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RsyncSpaceCheckTask, g_object_unref)
VALA_EXTERN void async_task_parse_stdout_line (AsyncTask* self,
                                   const gchar* out_line);
VALA_EXTERN void async_task_parse_stderr_line (AsyncTask* self,
                                   const gchar* err_line);
VALA_EXTERN void async_task_finish_task (AsyncTask* self);
VALA_EXTERN RsyncSpaceCheckTask* rsync_space_check_task_new (void);
VALA_EXTERN RsyncSpaceCheckTask* rsync_space_check_task_construct (GType object_type);
VALA_EXTERN AsyncTask* async_task_construct (GType object_type);
static void rsync_space_check_task_init_regular_expressions (RsyncSpaceCheckTask* self);
VALA_EXTERN void tee_jee_logging_log_error (const gchar* message,
                                gboolean highlight,
                                gboolean is_warning);
VALA_EXTERN void rsync_space_check_task_prepare (RsyncSpaceCheckTask* self);
static gchar* rsync_space_check_task_build_script (RsyncSpaceCheckTask* self);
VALA_EXTERN void tee_jee_logging_log_debug (const gchar* message);
VALA_EXTERN gchar* tee_jee_process_helper_save_bash_script_temp (const gchar* commands,
                                                     const gchar* script_path,
                                                     gboolean force_locale,
                                                     gboolean supress_errors);
VALA_EXTERN gchar* tee_jee_file_system_escape_single_quote (const gchar* file_path);
VALA_EXTERN gchar* tee_jee_file_system_remove_trailing_slash (const gchar* path);
VALA_EXTERN void rsync_space_check_task_execute (RsyncSpaceCheckTask* self);
VALA_EXTERN gboolean async_task_begin (AsyncTask* self);
static void rsync_space_check_task_real_parse_stdout_line (AsyncTask* base,
                                                    const gchar* out_line);
VALA_EXTERN gboolean rsync_space_check_task_update_progress_parse_console_output (RsyncSpaceCheckTask* self,
                                                                      const gchar* line);
static void rsync_space_check_task_real_parse_stderr_line (AsyncTask* base,
                                                    const gchar* err_line);
static void rsync_space_check_task_real_finish_task (AsyncTask* base);
VALA_EXTERN gint rsync_space_check_task_read_status (RsyncSpaceCheckTask* self);
VALA_EXTERN gchar* tee_jee_file_system_file_read (const gchar* file_path);
static void rsync_space_check_task_finalize (GObject * obj);
static GType rsync_space_check_task_get_type_once (void);

static inline gpointer
rsync_space_check_task_get_instance_private (RsyncSpaceCheckTask* self)
{
	return G_STRUCT_MEMBER_P (self, RsyncSpaceCheckTask_private_offset);
}

RsyncSpaceCheckTask*
rsync_space_check_task_construct (GType object_type)
{
	RsyncSpaceCheckTask * self = NULL;
	self = (RsyncSpaceCheckTask*) async_task_construct (object_type);
	rsync_space_check_task_init_regular_expressions (self);
	return self;
}

RsyncSpaceCheckTask*
rsync_space_check_task_new (void)
{
	return rsync_space_check_task_construct (TYPE_RSYNC_SPACE_CHECK_TASK);
}

static void
rsync_space_check_task_init_regular_expressions (RsyncSpaceCheckTask* self)
{
	GRegex* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->sent_bytes_regex;
	if (_tmp0_ != NULL) {
		return;
	}
	{
		GRegex* _tmp1_ = NULL;
		GRegex* _tmp2_;
		GRegex* _tmp3_;
		_tmp2_ = g_regex_new ("sent ([0-9,]+)[ \\t]+bytes[ \\t]+received", 0, 0, &_inner_error0_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		_g_regex_unref0 (self->priv->sent_bytes_regex);
		self->priv->sent_bytes_regex = _tmp3_;
		_g_regex_unref0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		tee_jee_logging_log_error (_tmp5_, FALSE, FALSE);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
rsync_space_check_task_prepare (RsyncSpaceCheckTask* self)
{
	gchar* script_text = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = rsync_space_check_task_build_script (self);
	script_text = _tmp0_;
	tee_jee_logging_log_debug (script_text);
	_tmp1_ = ((AsyncTask*) self)->script_file;
	_tmp2_ = tee_jee_process_helper_save_bash_script_temp (script_text, _tmp1_, TRUE, FALSE);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp3_);
	_tmp4_ = ((AsyncTask*) self)->script_file;
	_tmp5_ = g_strdup_printf ("RsyncSpaceCheckTask:prepare(): saved: %s", _tmp4_);
	_tmp6_ = _tmp5_;
	tee_jee_logging_log_debug (_tmp6_);
	_g_free0 (_tmp6_);
	self->total_size = (gint64) 0;
	self->status_line_count = (gint64) 0;
	_g_free0 (script_text);
}

static gchar*
rsync_space_check_task_build_script (RsyncSpaceCheckTask* self)
{
	gchar* cmd = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	const gchar* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	const gchar* _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	const gchar* _tmp49_;
	gchar* _tmp50_;
	const gchar* _tmp51_;
	gchar* _tmp52_;
	const gchar* _tmp53_;
	const gchar* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	const gchar* _tmp60_;
	const gchar* _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	gchar* _tmp64_;
	gchar* _tmp65_;
	gchar* _tmp66_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("export LC_ALL=C.UTF-8\n");
	cmd = _tmp0_;
	_tmp1_ = cmd;
	_tmp2_ = g_strconcat (_tmp1_, "rsync -aii", NULL);
	_g_free0 (cmd);
	cmd = _tmp2_;
	_tmp3_ = cmd;
	_tmp4_ = g_strconcat (_tmp3_, " --recursive", NULL);
	_g_free0 (cmd);
	cmd = _tmp4_;
	if (self->verbose) {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = cmd;
		_tmp6_ = g_strconcat (_tmp5_, " --verbose", NULL);
		_g_free0 (cmd);
		cmd = _tmp6_;
	} else {
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = cmd;
		_tmp8_ = g_strconcat (_tmp7_, " --quiet", NULL);
		_g_free0 (cmd);
		cmd = _tmp8_;
	}
	if (self->delete_extra) {
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp9_ = cmd;
		_tmp10_ = g_strconcat (_tmp9_, " --delete", NULL);
		_g_free0 (cmd);
		cmd = _tmp10_;
	}
	if (self->delete_after) {
		const gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp11_ = cmd;
		_tmp12_ = g_strconcat (_tmp11_, " --delete-after", NULL);
		_g_free0 (cmd);
		cmd = _tmp12_;
	}
	_tmp13_ = cmd;
	_tmp14_ = g_strconcat (_tmp13_, " --force", NULL);
	_g_free0 (cmd);
	cmd = _tmp14_;
	_tmp15_ = cmd;
	_tmp16_ = g_strconcat (_tmp15_, " --stats", NULL);
	_g_free0 (cmd);
	cmd = _tmp16_;
	_tmp17_ = cmd;
	_tmp18_ = g_strconcat (_tmp17_, " --sparse", NULL);
	_g_free0 (cmd);
	cmd = _tmp18_;
	if (self->delete_excluded) {
		const gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp19_ = cmd;
		_tmp20_ = g_strconcat (_tmp19_, " --delete-excluded", NULL);
		_g_free0 (cmd);
		cmd = _tmp20_;
	}
	_tmp21_ = cmd;
	_tmp22_ = g_strconcat (_tmp21_, " --dry-run", NULL);
	_g_free0 (cmd);
	cmd = _tmp22_;
	_tmp23_ = self->link_from_path;
	_tmp24_ = strlen (_tmp23_);
	_tmp25_ = _tmp24_;
	if (_tmp25_ > 0) {
		const gchar* _tmp26_;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		_tmp26_ = self->link_from_path;
		if (!g_str_has_suffix (_tmp26_, "/")) {
			const gchar* _tmp27_;
			gchar* _tmp28_;
			_tmp27_ = self->link_from_path;
			_tmp28_ = g_strdup_printf ("%s/", _tmp27_);
			_g_free0 (self->link_from_path);
			self->link_from_path = _tmp28_;
		}
		_tmp29_ = cmd;
		_tmp30_ = self->link_from_path;
		_tmp31_ = tee_jee_file_system_escape_single_quote (_tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = g_strdup_printf (" --link-dest='%s'", _tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = g_strconcat (_tmp29_, _tmp34_, NULL);
		_g_free0 (cmd);
		cmd = _tmp35_;
		_g_free0 (_tmp34_);
		_g_free0 (_tmp32_);
	}
	_tmp36_ = self->exclude_from_file;
	_tmp37_ = strlen (_tmp36_);
	_tmp38_ = _tmp37_;
	if (_tmp38_ > 0) {
		const gchar* _tmp39_;
		const gchar* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		gboolean _tmp46_ = FALSE;
		_tmp39_ = cmd;
		_tmp40_ = self->exclude_from_file;
		_tmp41_ = tee_jee_file_system_escape_single_quote (_tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_ = g_strdup_printf (" --exclude-from='%s'", _tmp42_);
		_tmp44_ = _tmp43_;
		_tmp45_ = g_strconcat (_tmp39_, _tmp44_, NULL);
		_g_free0 (cmd);
		cmd = _tmp45_;
		_g_free0 (_tmp44_);
		_g_free0 (_tmp42_);
		if (self->delete_extra) {
			_tmp46_ = self->delete_excluded;
		} else {
			_tmp46_ = FALSE;
		}
		if (_tmp46_) {
			const gchar* _tmp47_;
			gchar* _tmp48_;
			_tmp47_ = cmd;
			_tmp48_ = g_strconcat (_tmp47_, " --delete-excluded", NULL);
			_g_free0 (cmd);
			cmd = _tmp48_;
		}
	}
	_tmp49_ = self->source_path;
	_tmp50_ = tee_jee_file_system_remove_trailing_slash (_tmp49_);
	_g_free0 (self->source_path);
	self->source_path = _tmp50_;
	_tmp51_ = self->dest_path;
	_tmp52_ = tee_jee_file_system_remove_trailing_slash (_tmp51_);
	_g_free0 (self->dest_path);
	self->dest_path = _tmp52_;
	_tmp53_ = cmd;
	_tmp54_ = self->source_path;
	_tmp55_ = tee_jee_file_system_escape_single_quote (_tmp54_);
	_tmp56_ = _tmp55_;
	_tmp57_ = g_strdup_printf (" '%s/'", _tmp56_);
	_tmp58_ = _tmp57_;
	_tmp59_ = g_strconcat (_tmp53_, _tmp58_, NULL);
	_g_free0 (cmd);
	cmd = _tmp59_;
	_g_free0 (_tmp58_);
	_g_free0 (_tmp56_);
	_tmp60_ = cmd;
	_tmp61_ = self->dest_path;
	_tmp62_ = tee_jee_file_system_escape_single_quote (_tmp61_);
	_tmp63_ = _tmp62_;
	_tmp64_ = g_strdup_printf (" '%s/'", _tmp63_);
	_tmp65_ = _tmp64_;
	_tmp66_ = g_strconcat (_tmp60_, _tmp65_, NULL);
	_g_free0 (cmd);
	cmd = _tmp66_;
	_g_free0 (_tmp65_);
	_g_free0 (_tmp63_);
	result = cmd;
	return result;
}

void
rsync_space_check_task_execute (RsyncSpaceCheckTask* self)
{
	g_return_if_fail (self != NULL);
	tee_jee_logging_log_debug ("RsyncSpaceCheckTask:execute()");
	rsync_space_check_task_prepare (self);
	async_task_begin ((AsyncTask*) self);
}

static void
rsync_space_check_task_real_parse_stdout_line (AsyncTask* base,
                                               const gchar* out_line)
{
	RsyncSpaceCheckTask * self;
	self = (RsyncSpaceCheckTask*) base;
	g_return_if_fail (out_line != NULL);
	if (((AsyncTask*) self)->is_terminated) {
		return;
	}
	rsync_space_check_task_update_progress_parse_console_output (self, out_line);
}

static void
rsync_space_check_task_real_parse_stderr_line (AsyncTask* base,
                                               const gchar* err_line)
{
	RsyncSpaceCheckTask * self;
	self = (RsyncSpaceCheckTask*) base;
	g_return_if_fail (err_line != NULL);
	if (((AsyncTask*) self)->is_terminated) {
		return;
	}
	rsync_space_check_task_update_progress_parse_console_output (self, err_line);
}

static gint64
int64_parse (const gchar* str,
             guint _base)
{
	gint64 result;
	g_return_val_if_fail (str != NULL, 0LL);
	result = g_ascii_strtoll (str, NULL, _base);
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gboolean
rsync_space_check_task_update_progress_parse_console_output (RsyncSpaceCheckTask* self,
                                                             const gchar* line)
{
	gboolean _tmp0_ = FALSE;
	gint64 _tmp3_;
	GMatchInfo* match = NULL;
	GRegex* _tmp4_;
	GMatchInfo* _tmp5_ = NULL;
	gboolean _tmp6_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	if (line == NULL) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (line);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == 0;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	_tmp3_ = self->status_line_count;
	self->status_line_count = _tmp3_ + 1;
	if (((AsyncTask*) self)->prg_count_total > ((gint64) 0)) {
		((AsyncTask*) self)->prg_count = self->status_line_count;
		((AsyncTask*) self)->progress = (((AsyncTask*) self)->prg_count * 1.0) / ((AsyncTask*) self)->prg_count_total;
	}
	_tmp4_ = self->priv->sent_bytes_regex;
	_tmp6_ = g_regex_match (_tmp4_, line, 0, &_tmp5_);
	_g_match_info_unref0 (match);
	match = _tmp5_;
	if (_tmp6_) {
		GMatchInfo* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp7_ = match;
		_tmp8_ = g_match_info_fetch (_tmp7_, 1);
		_tmp9_ = _tmp8_;
		_tmp10_ = string_replace (_tmp9_, ",", "");
		_tmp11_ = _tmp10_;
		self->total_size = int64_parse (_tmp11_, (guint) 0);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
	} else {
	}
	result = TRUE;
	_g_match_info_unref0 (match);
	return result;
}

static void
rsync_space_check_task_real_finish_task (AsyncTask* base)
{
	RsyncSpaceCheckTask * self;
	gboolean _tmp0_ = FALSE;
	self = (RsyncSpaceCheckTask*) base;
	if (((AsyncTask*) self)->status != APP_STATUS_CANCELLED) {
		_tmp0_ = ((AsyncTask*) self)->status != APP_STATUS_PASSWORD_REQUIRED;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		((AsyncTask*) self)->status = APP_STATUS_FINISHED;
	}
}

gint
rsync_space_check_task_read_status (RsyncSpaceCheckTask* self)
{
	gchar* status_file = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* f = NULL;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = ((AsyncTask*) self)->working_dir;
	_tmp1_ = g_strconcat (_tmp0_, "/status", NULL);
	status_file = _tmp1_;
	_tmp2_ = status_file;
	_tmp3_ = g_file_new_for_path (_tmp2_);
	f = _tmp3_;
	_tmp4_ = f;
	if (g_file_query_exists (_tmp4_, NULL)) {
		gchar* txt = NULL;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp5_ = status_file;
		_tmp6_ = tee_jee_file_system_file_read (_tmp5_);
		txt = _tmp6_;
		_tmp7_ = txt;
		result = atoi (_tmp7_);
		_g_free0 (txt);
		_g_object_unref0 (f);
		_g_free0 (status_file);
		return result;
	}
	result = -1;
	_g_object_unref0 (f);
	_g_free0 (status_file);
	return result;
}

static void
rsync_space_check_task_class_init (RsyncSpaceCheckTaskClass * klass,
                                   gpointer klass_data)
{
	rsync_space_check_task_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RsyncSpaceCheckTask_private_offset);
	((AsyncTaskClass *) klass)->parse_stdout_line = (void (*) (AsyncTask*, const gchar*)) rsync_space_check_task_real_parse_stdout_line;
	((AsyncTaskClass *) klass)->parse_stderr_line = (void (*) (AsyncTask*, const gchar*)) rsync_space_check_task_real_parse_stderr_line;
	((AsyncTaskClass *) klass)->finish_task = (void (*) (AsyncTask*)) rsync_space_check_task_real_finish_task;
	G_OBJECT_CLASS (klass)->finalize = rsync_space_check_task_finalize;
}

static void
rsync_space_check_task_instance_init (RsyncSpaceCheckTask * self,
                                      gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	self->priv = rsync_space_check_task_get_instance_private (self);
	self->delete_extra = TRUE;
	self->delete_after = FALSE;
	self->delete_excluded = FALSE;
	self->relative = FALSE;
	_tmp0_ = g_strdup ("");
	self->exclude_from_file = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->link_from_path = _tmp1_;
	_tmp2_ = g_strdup ("");
	self->source_path = _tmp2_;
	_tmp3_ = g_strdup ("");
	self->dest_path = _tmp3_;
	self->verbose = TRUE;
	self->io_nice = TRUE;
	self->dry_run = FALSE;
	self->status_line_count = (gint64) 0;
	self->total_size = (gint64) 0;
}

static void
rsync_space_check_task_finalize (GObject * obj)
{
	RsyncSpaceCheckTask * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTask);
	_g_free0 (self->exclude_from_file);
	_g_free0 (self->link_from_path);
	_g_free0 (self->source_path);
	_g_free0 (self->dest_path);
	_g_regex_unref0 (self->priv->sent_bytes_regex);
	G_OBJECT_CLASS (rsync_space_check_task_parent_class)->finalize (obj);
}

static GType
rsync_space_check_task_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RsyncSpaceCheckTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rsync_space_check_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RsyncSpaceCheckTask), 0, (GInstanceInitFunc) rsync_space_check_task_instance_init, NULL };
	GType rsync_space_check_task_type_id;
	rsync_space_check_task_type_id = g_type_register_static (TYPE_ASYNC_TASK, "RsyncSpaceCheckTask", &g_define_type_info, 0);
	RsyncSpaceCheckTask_private_offset = g_type_add_instance_private (rsync_space_check_task_type_id, sizeof (RsyncSpaceCheckTaskPrivate));
	return rsync_space_check_task_type_id;
}

GType
rsync_space_check_task_get_type (void)
{
	static volatile gsize rsync_space_check_task_type_id__once = 0;
	if (g_once_init_enter (&rsync_space_check_task_type_id__once)) {
		GType rsync_space_check_task_type_id;
		rsync_space_check_task_type_id = rsync_space_check_task_get_type_once ();
		g_once_init_leave (&rsync_space_check_task_type_id__once, rsync_space_check_task_type_id);
	}
	return rsync_space_check_task_type_id__once;
}

