/* TeeJee.Json.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from TeeJee.Json.vala, do not modify */

/*
 * TeeJee.JsonHelper.vala
 *
 * Copyright 2012-2018 Tony George <teejeetech@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 *
 */

#include <json-glib/json-glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))

VALA_EXTERN gchar* tee_jee_json_helper_json_get_string (JsonObject* jobj,
                                            const gchar* member,
                                            const gchar* def_value);
VALA_EXTERN void tee_jee_logging_log_debug (const gchar* message);
VALA_EXTERN gboolean tee_jee_json_helper_json_get_bool (JsonObject* jobj,
                                            const gchar* member,
                                            gboolean def_value);
VALA_EXTERN gint tee_jee_json_helper_json_get_int (JsonObject* jobj,
                                       const gchar* member,
                                       gint def_value);
VALA_EXTERN guint64 tee_jee_json_helper_json_get_uint64 (JsonObject* jobj,
                                             const gchar* member,
                                             guint64 def_value);

gchar*
tee_jee_json_helper_json_get_string (JsonObject* jobj,
                                     const gchar* member,
                                     const gchar* def_value)
{
	gchar* result;
	g_return_val_if_fail (jobj != NULL, NULL);
	g_return_val_if_fail (member != NULL, NULL);
	g_return_val_if_fail (def_value != NULL, NULL);
	if (json_object_has_member (jobj, member)) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = json_object_get_string_member (jobj, member);
		_tmp1_ = g_strdup (_tmp0_);
		result = _tmp1_;
		return result;
	} else {
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = g_strconcat ("Member not found in JSON object: ", member, NULL);
		_tmp3_ = _tmp2_;
		tee_jee_logging_log_debug (_tmp3_);
		_g_free0 (_tmp3_);
		_tmp4_ = g_strdup (def_value);
		result = _tmp4_;
		return result;
	}
}

static gboolean
bool_parse (const gchar* str)
{
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	if (g_strcmp0 (str, "true") == 0) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

gboolean
tee_jee_json_helper_json_get_bool (JsonObject* jobj,
                                   const gchar* member,
                                   gboolean def_value)
{
	gboolean result;
	g_return_val_if_fail (jobj != NULL, FALSE);
	g_return_val_if_fail (member != NULL, FALSE);
	if (json_object_has_member (jobj, member)) {
		const gchar* _tmp0_;
		_tmp0_ = json_object_get_string_member (jobj, member);
		result = bool_parse (_tmp0_);
		return result;
	} else {
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = g_strconcat ("Member not found in JSON object: ", member, NULL);
		_tmp2_ = _tmp1_;
		tee_jee_logging_log_debug (_tmp2_);
		_g_free0 (_tmp2_);
		result = def_value;
		return result;
	}
}

gint
tee_jee_json_helper_json_get_int (JsonObject* jobj,
                                  const gchar* member,
                                  gint def_value)
{
	gint result;
	g_return_val_if_fail (jobj != NULL, 0);
	g_return_val_if_fail (member != NULL, 0);
	if (json_object_has_member (jobj, member)) {
		const gchar* _tmp0_;
		_tmp0_ = json_object_get_string_member (jobj, member);
		result = atoi (_tmp0_);
		return result;
	} else {
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = g_strconcat ("Member not found in JSON object: ", member, NULL);
		_tmp2_ = _tmp1_;
		tee_jee_logging_log_debug (_tmp2_);
		_g_free0 (_tmp2_);
		result = def_value;
		return result;
	}
}

static guint64
uint64_parse (const gchar* str,
              guint _base)
{
	guint64 result;
	g_return_val_if_fail (str != NULL, 0ULL);
	result = g_ascii_strtoull (str, NULL, _base);
	return result;
}

guint64
tee_jee_json_helper_json_get_uint64 (JsonObject* jobj,
                                     const gchar* member,
                                     guint64 def_value)
{
	guint64 result;
	g_return_val_if_fail (jobj != NULL, 0ULL);
	g_return_val_if_fail (member != NULL, 0ULL);
	if (json_object_has_member (jobj, member)) {
		const gchar* _tmp0_;
		_tmp0_ = json_object_get_string_member (jobj, member);
		result = uint64_parse (_tmp0_, (guint) 0);
		return result;
	} else {
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = g_strconcat ("Member not found in JSON object: ", member, NULL);
		_tmp2_ = _tmp1_;
		tee_jee_logging_log_debug (_tmp2_);
		_g_free0 (_tmp2_);
		result = def_value;
		return result;
	}
}

