/* Generated by wayland-scanner 1.24.0 */

#ifndef TREELAND_WALLPAPER_COLOR_V1_SERVER_PROTOCOL_H
#define TREELAND_WALLPAPER_COLOR_V1_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_treeland_wallpaper_color_v1 The treeland_wallpaper_color_v1 protocol
 * @section page_ifaces_treeland_wallpaper_color_v1 Interfaces
 * - @subpage page_iface_treeland_wallpaper_color_manager_v1 - 
 * @section page_copyright_treeland_wallpaper_color_v1 Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2024 UnionTech Software Technology Co., Ltd.
 * SPDX-License-Identifier: MIT
 * </pre>
 */
struct treeland_wallpaper_color_manager_v1;

#ifndef TREELAND_WALLPAPER_COLOR_MANAGER_V1_INTERFACE
#define TREELAND_WALLPAPER_COLOR_MANAGER_V1_INTERFACE
/**
 * @page page_iface_treeland_wallpaper_color_manager_v1 treeland_wallpaper_color_manager_v1
 * @section page_iface_treeland_wallpaper_color_manager_v1_api API
 * See @ref iface_treeland_wallpaper_color_manager_v1.
 */
/**
 * @defgroup iface_treeland_wallpaper_color_manager_v1 The treeland_wallpaper_color_manager_v1 interface
 */
extern const struct wl_interface treeland_wallpaper_color_manager_v1_interface;
#endif

/**
 * @ingroup iface_treeland_wallpaper_color_manager_v1
 * @struct treeland_wallpaper_color_manager_v1_interface
 */
struct treeland_wallpaper_color_manager_v1_interface {
	/**
	 * watch wallpaper color
	 *
	 * Monitor the wallpaper color of a given screen.
	 * @param output system output name
	 */
	void (*watch)(struct wl_client *client,
		      struct wl_resource *resource,
		      const char *output);
	/**
	 * unwatch wallpaper color
	 *
	 * Stop monitor the wallpaper color for the given screen.
	 * @param output system output name
	 */
	void (*unwatch)(struct wl_client *client,
			struct wl_resource *resource,
			const char *output);
	/**
	 * destroy the context object
	 *
	 * The client no longer cares about wallpaper_color.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};

#define TREELAND_WALLPAPER_COLOR_MANAGER_V1_OUTPUT_COLOR 0

/**
 * @ingroup iface_treeland_wallpaper_color_manager_v1
 */
#define TREELAND_WALLPAPER_COLOR_MANAGER_V1_OUTPUT_COLOR_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_wallpaper_color_manager_v1
 */
#define TREELAND_WALLPAPER_COLOR_MANAGER_V1_WATCH_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_wallpaper_color_manager_v1
 */
#define TREELAND_WALLPAPER_COLOR_MANAGER_V1_UNWATCH_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_wallpaper_color_manager_v1
 */
#define TREELAND_WALLPAPER_COLOR_MANAGER_V1_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_wallpaper_color_manager_v1
 * Sends an output_color event to the client owning the resource.
 * @param resource_ The client's resource
 * @param output system output name
 */
static inline void
treeland_wallpaper_color_manager_v1_send_output_color(struct wl_resource *resource_, const char *output, uint32_t isdark)
{
	wl_resource_post_event(resource_, TREELAND_WALLPAPER_COLOR_MANAGER_V1_OUTPUT_COLOR, output, isdark);
}

#ifdef  __cplusplus
}
#endif

#endif
