/* valabindwriter.c generated by valac 0.56.17, the Vala compiler
 * generated from valabindwriter.vala, do not modify */

/* Copyright 2009-2015 -- pancake */

#include <vala.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gstdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_VALABIND_WRITER (valabind_writer_get_type ())
#define VALABIND_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VALABIND_WRITER, ValabindWriter))
#define VALABIND_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VALABIND_WRITER, ValabindWriterClass))
#define IS_VALABIND_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VALABIND_WRITER))
#define IS_VALABIND_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VALABIND_WRITER))
#define VALABIND_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VALABIND_WRITER, ValabindWriterClass))

typedef struct _ValabindWriter ValabindWriter;
typedef struct _ValabindWriterClass ValabindWriterClass;
typedef struct _ValabindWriterPrivate ValabindWriterPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _ValabindWriter {
	ValaCodeVisitor parent_instance;
	ValabindWriterPrivate * priv;
	gchar* modulename;
	gchar* library;
	gboolean pkgmode;
	gboolean camelgetters;
	gchar* pkgname;
	gchar** include_dirs;
	gchar** namespaces;
	ValaCodeContext* context;
	gchar* vapidir;
	GList* source_files;
	GList* packages;
	GList* defines;
	gboolean glibmode;
};

struct _ValabindWriterClass {
	ValaCodeVisitorClass parent_class;
	void (*write) (ValabindWriter* self, const gchar* file);
	gchar* (*get_filename) (ValabindWriter* self, const gchar* base_name);
};

static gpointer valabind_writer_parent_class = NULL;

VALA_EXTERN GType valabind_writer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ValabindWriter, vala_code_visitor_unref)
VALA_EXTERN void valabind_writer_write (ValabindWriter* self,
                            const gchar* file);
VALA_EXTERN gchar* valabind_writer_get_filename (ValabindWriter* self,
                                     const gchar* base_name);
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
VALA_EXTERN ValabindWriter* valabind_writer_new (void);
VALA_EXTERN ValabindWriter* valabind_writer_construct (GType object_type);
VALA_EXTERN void valabind_writer_init (ValabindWriter* self,
                           const gchar* vapidir,
                           gboolean glibmode);
static gboolean valabind_writer_add_package (ValabindWriter* self,
                                      ValaCodeContext* context,
                                      const gchar* pkg);
VALA_EXTERN void valabind_writer_parse (ValabindWriter* self);
VALA_EXTERN gboolean valabind_writer_check (ValabindWriter* self);
VALA_EXTERN void error (const gchar* msg);
VALA_EXTERN void valabind_writer_add_define (ValabindWriter* self,
                                 const gchar* define);
VALA_EXTERN void notice (const gchar* msg);
VALA_EXTERN gboolean valabind_writer_add_external_package (ValabindWriter* self,
                                               const gchar* pkg);
VALA_EXTERN gboolean valabind_writer_add_source_file (ValabindWriter* self,
                                          const gchar* path);
VALA_EXTERN void warning (const gchar* msg);
VALA_EXTERN gboolean valabind_writer_use_namespace (ValabindWriter* self,
                                        ValaNamespace* ns);
static void valabind_writer_real_write (ValabindWriter* self,
                                 const gchar* file);
static gchar* valabind_writer_real_get_filename (ValabindWriter* self,
                                          const gchar* base_name);
static void valabind_writer_finalize (ValaCodeVisitor * obj);
static GType valabind_writer_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}

ValabindWriter*
valabind_writer_construct (GType object_type)
{
	ValabindWriter* self = NULL;
	self = (ValabindWriter*) vala_code_visitor_construct (object_type);
	return self;
}

ValabindWriter*
valabind_writer_new (void)
{
	return valabind_writer_construct (TYPE_VALABIND_WRITER);
}

void
valabind_writer_init (ValabindWriter* self,
                      const gchar* vapidir,
                      gboolean glibmode)
{
	ValaCodeContext* _tmp0_;
	gchar* _tmp1_;
	ValaCodeContext* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	ValaCodeContext* _tmp6_;
	ValaCodeContext* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (vapidir != NULL);
	_tmp0_ = self->context;
	vala_code_context_push (_tmp0_);
	_tmp1_ = g_strdup (vapidir);
	_g_free0 (self->vapidir);
	self->vapidir = _tmp1_;
	self->glibmode = glibmode;
	_tmp2_ = self->context;
	_tmp3_ = g_strdup (vapidir);
	_tmp4_ = g_new0 (gchar*, 1 + 1);
	_tmp4_[0] = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = 1;
	vala_code_context_set_vapi_directories (_tmp2_, _tmp5_, 1);
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
	_tmp6_ = self->context;
	valabind_writer_add_package (self, _tmp6_, "glib-2.0");
	_tmp7_ = self->context;
	valabind_writer_add_package (self, _tmp7_, "gobject-2.0");
	if (glibmode) {
		ValaCodeContext* _tmp8_;
		_tmp8_ = self->context;
		vala_code_context_add_define (_tmp8_, "GOBJECT");
	}
}

void
valabind_writer_parse (ValabindWriter* self)
{
	ValaParser* parser = NULL;
	ValaParser* _tmp0_;
	ValaParser* _tmp1_;
	ValaCodeContext* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_parser_new ();
	parser = _tmp0_;
	_tmp1_ = parser;
	_tmp2_ = self->context;
	vala_parser_parse (_tmp1_, _tmp2_);
	if (!valabind_writer_check (self)) {
		error ("Problems found, aborting...");
	}
	_vala_code_visitor_unref0 (parser);
}

gboolean
valabind_writer_check (ValabindWriter* self)
{
	ValaCodeContext* _tmp0_;
	ValaCodeContext* _tmp1_;
	ValaReport* _tmp2_;
	ValaReport* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->context;
	vala_code_context_check (_tmp0_);
	_tmp1_ = self->context;
	_tmp2_ = vala_code_context_get_report (_tmp1_);
	_tmp3_ = _tmp2_;
	result = vala_report_get_errors (_tmp3_) == 0;
	return result;
}

void
valabind_writer_add_define (ValabindWriter* self,
                            const gchar* define)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	ValaCodeContext* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (define != NULL);
	_tmp0_ = g_strconcat ("Symbol defined ", define, NULL);
	_tmp1_ = _tmp0_;
	notice (_tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = g_strdup (define);
	self->defines = g_list_append (self->defines, _tmp2_);
	_tmp3_ = self->context;
	vala_code_context_add_define (_tmp3_, define);
}

gboolean
valabind_writer_add_external_package (ValabindWriter* self,
                                      const gchar* pkg)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	ValaCodeContext* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (pkg != NULL, FALSE);
	_tmp0_ = g_strconcat ("Adding dependency ", pkg, NULL);
	_tmp1_ = _tmp0_;
	notice (_tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = g_strdup (pkg);
	self->packages = g_list_append (self->packages, _tmp2_);
	_tmp3_ = self->context;
	result = vala_code_context_add_external_package (_tmp3_, pkg);
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gboolean
valabind_writer_add_source_file (ValabindWriter* self,
                                 const gchar* path)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GList* _tmp2_;
	gboolean found = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	if (g_strcmp0 (path, "") == 0) {
		error ("Missing path to source vapi");
		result = FALSE;
		return result;
	}
	_tmp0_ = string_replace (path, ".vapi", "");
	_tmp1_ = _tmp0_;
	_g_free0 (_tmp1_);
	_tmp2_ = self->source_files;
	{
		GList* f_collection = NULL;
		GList* f_it = NULL;
		f_collection = _tmp2_;
		for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
			gchar* _tmp3_;
			gchar* f = NULL;
			_tmp3_ = g_strdup ((const gchar*) f_it->data);
			f = _tmp3_;
			{
				const gchar* _tmp4_;
				_tmp4_ = f;
				if (g_strcmp0 (path, _tmp4_) == 0) {
					result = FALSE;
					_g_free0 (f);
					return result;
				}
				_g_free0 (f);
			}
		}
	}
	found = g_file_test (path, G_FILE_TEST_IS_REGULAR);
	if (found) {
		gchar* _tmp9_;
		if (!self->pkgmode) {
			ValaCodeContext* _tmp5_;
			ValaCodeContext* _tmp6_;
			ValaSourceFile* _tmp7_;
			ValaSourceFile* _tmp8_;
			_tmp5_ = self->context;
			_tmp6_ = self->context;
			_tmp7_ = vala_source_file_new (_tmp6_, VALA_SOURCE_FILE_TYPE_PACKAGE, path, NULL, FALSE);
			_tmp8_ = _tmp7_;
			vala_code_context_add_source_file (_tmp5_, _tmp8_);
			_vala_source_file_unref0 (_tmp8_);
		}
		_tmp9_ = g_strdup (path);
		self->source_files = g_list_append (self->source_files, _tmp9_);
	} else {
		ValaCodeContext* _tmp10_;
		_tmp10_ = self->context;
		if (!valabind_writer_add_package (self, _tmp10_, path)) {
			gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp11_ = g_strdup_printf ("Cannot find '%s'", path);
			_tmp12_ = _tmp11_;
			error (_tmp12_);
			_g_free0 (_tmp12_);
		}
	}
	result = found;
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gboolean
valabind_writer_add_package (ValabindWriter* self,
                             ValaCodeContext* context,
                             const gchar* pkg)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* package_path = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSourceFile* _tmp9_;
	gchar* deps_filename = NULL;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	g_return_val_if_fail (pkg != NULL, FALSE);
	if (g_strcmp0 (pkg, "") == 0) {
		warning ("Empty add_package()?");
		result = TRUE;
		return result;
	}
	if (vala_code_context_has_package (context, pkg)) {
		result = TRUE;
		return result;
	}
	_tmp0_ = g_strconcat ("Adding dependency package ", pkg, NULL);
	_tmp1_ = _tmp0_;
	notice (_tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = vala_code_context_get_vapi_path (context, pkg);
	package_path = _tmp2_;
	_tmp3_ = package_path;
	if (_tmp3_ == NULL) {
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = g_strdup_printf ("Cannot find package path '%s'", pkg);
		_tmp5_ = _tmp4_;
		warning (_tmp5_);
		_g_free0 (_tmp5_);
		result = FALSE;
		_g_free0 (package_path);
		return result;
	}
	if (self->pkgmode) {
		const gchar* _tmp6_;
		_tmp6_ = package_path;
		valabind_writer_add_source_file (self, _tmp6_);
	}
	_tmp7_ = package_path;
	_tmp8_ = vala_source_file_new (context, VALA_SOURCE_FILE_TYPE_PACKAGE, _tmp7_, NULL, FALSE);
	_tmp9_ = _tmp8_;
	vala_code_context_add_source_file (context, _tmp9_);
	_vala_source_file_unref0 (_tmp9_);
	vala_code_context_add_package (context, pkg);
	_tmp10_ = package_path;
	_tmp11_ = g_path_get_dirname (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strdup_printf ("%s.deps", pkg);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_build_filename (_tmp12_, _tmp14_, NULL);
	_tmp16_ = _tmp15_;
	_g_free0 (_tmp14_);
	_g_free0 (_tmp12_);
	deps_filename = _tmp16_;
	_tmp17_ = deps_filename;
	if (g_file_test (_tmp17_, G_FILE_TEST_EXISTS)) {
		{
			gchar* deps_content = NULL;
			gsize deps_len = 0UL;
			const gchar* _tmp18_;
			gchar* _tmp19_ = NULL;
			gsize _tmp20_ = 0UL;
			const gchar* _tmp22_;
			gchar** _tmp23_;
			gchar** _tmp24_;
			_tmp18_ = deps_filename;
			g_file_get_contents (_tmp18_, &_tmp19_, &_tmp20_, &_inner_error0_);
			_g_free0 (deps_content);
			deps_content = _tmp19_;
			deps_len = _tmp20_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp21_ = FALSE;
				_g_free0 (deps_content);
				if (_inner_error0_->domain == G_FILE_ERROR) {
					goto __catch0_g_file_error;
				}
				_g_free0 (deps_filename);
				_g_free0 (package_path);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp21_;
			}
			_tmp22_ = deps_content;
			_tmp24_ = _tmp23_ = g_strsplit (_tmp22_, "\n", 0);
			{
				gchar** dep_collection = NULL;
				gint dep_collection_length1 = 0;
				gint _dep_collection_size_ = 0;
				gint dep_it = 0;
				dep_collection = _tmp24_;
				dep_collection_length1 = _vala_array_length (_tmp23_);
				for (dep_it = 0; dep_it < dep_collection_length1; dep_it = dep_it + 1) {
					gchar* _tmp25_;
					gchar* dep = NULL;
					_tmp25_ = g_strdup (dep_collection[dep_it]);
					dep = _tmp25_;
					{
						const gchar* _tmp26_;
						gchar* _tmp27_;
						const gchar* _tmp28_;
						_tmp26_ = dep;
						_tmp27_ = string_strip (_tmp26_);
						_g_free0 (dep);
						dep = _tmp27_;
						_tmp28_ = dep;
						if (g_strcmp0 (_tmp28_, "") != 0) {
							const gchar* _tmp29_;
							_tmp29_ = dep;
							if (!valabind_writer_add_package (self, context, _tmp29_)) {
								const gchar* _tmp30_;
								gchar* _tmp31_;
								gchar* _tmp32_;
								_tmp30_ = dep;
								_tmp31_ = g_strdup_printf ("%s, dependency of %s, not found in specified Vala API directories", _tmp30_, pkg);
								_tmp32_ = _tmp31_;
								vala_report_error (NULL, "%s", _tmp32_);
								_g_free0 (_tmp32_);
							}
						}
						_g_free0 (dep);
					}
				}
				dep_collection = (_vala_array_free (dep_collection, dep_collection_length1, (GDestroyNotify) g_free), NULL);
			}
			_g_free0 (deps_content);
		}
		goto __finally0;
		__catch0_g_file_error:
		{
			GError* e = NULL;
			GError* _tmp33_;
			const gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp33_ = e;
			_tmp34_ = _tmp33_->message;
			_tmp35_ = g_strdup_printf ("Unable to read dependency file: %s", _tmp34_);
			_tmp36_ = _tmp35_;
			vala_report_error (NULL, "%s", _tmp36_);
			_g_free0 (_tmp36_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp37_ = FALSE;
			_g_free0 (deps_filename);
			_g_free0 (package_path);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp37_;
		}
	}
	result = TRUE;
	_g_free0 (deps_filename);
	_g_free0 (package_path);
	return result;
}

gboolean
valabind_writer_use_namespace (ValabindWriter* self,
                               ValaNamespace* ns)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar* name = NULL;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (ns != NULL, FALSE);
	_tmp0_ = self->namespaces;
	_tmp0__length1 = _vala_array_length (self->namespaces);
	if (_tmp0_ == NULL) {
		result = TRUE;
		return result;
	}
	_tmp1_ = vala_symbol_get_full_name ((ValaSymbol*) ns);
	name = _tmp1_;
	_tmp2_ = self->namespaces;
	_tmp2__length1 = _vala_array_length (self->namespaces);
	{
		gchar** i_collection = NULL;
		gint i_collection_length1 = 0;
		gint _i_collection_size_ = 0;
		gint i_it = 0;
		i_collection = _tmp2_;
		i_collection_length1 = _tmp2__length1;
		for (i_it = 0; i_it < i_collection_length1; i_it = i_it + 1) {
			gchar* _tmp3_;
			gchar* i = NULL;
			_tmp3_ = g_strdup (i_collection[i_it]);
			i = _tmp3_;
			{
				const gchar* _tmp4_;
				const gchar* _tmp5_;
				_tmp4_ = name;
				_tmp5_ = i;
				if (g_strcmp0 (_tmp4_, _tmp5_) == 0) {
					result = TRUE;
					_g_free0 (i);
					_g_free0 (name);
					return result;
				}
				_g_free0 (i);
			}
		}
	}
	result = FALSE;
	_g_free0 (name);
	return result;
}

static void
valabind_writer_real_write (ValabindWriter* self,
                            const gchar* file)
{
	g_return_if_fail (file != NULL);
	error ("ValabindWriter.write not implemented");
}

void
valabind_writer_write (ValabindWriter* self,
                       const gchar* file)
{
	ValabindWriterClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = VALABIND_WRITER_GET_CLASS (self);
	if (_klass_->write) {
		_klass_->write (self, file);
	}
}

static gchar*
valabind_writer_real_get_filename (ValabindWriter* self,
                                   const gchar* base_name)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (base_name != NULL, NULL);
	warning ("ValabindWriter.get_filename not implemented");
	_tmp0_ = g_strdup (base_name);
	result = _tmp0_;
	return result;
}

gchar*
valabind_writer_get_filename (ValabindWriter* self,
                              const gchar* base_name)
{
	ValabindWriterClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = VALABIND_WRITER_GET_CLASS (self);
	if (_klass_->get_filename) {
		return _klass_->get_filename (self, base_name);
	}
	return NULL;
}

static void
valabind_writer_class_init (ValabindWriterClass * klass,
                            gpointer klass_data)
{
	valabind_writer_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->finalize = valabind_writer_finalize;
	((ValabindWriterClass *) klass)->write = (void (*) (ValabindWriter*, const gchar*)) valabind_writer_real_write;
	((ValabindWriterClass *) klass)->get_filename = (gchar* (*) (ValabindWriter*, const gchar*)) valabind_writer_real_get_filename;
}

static void
valabind_writer_instance_init (ValabindWriter * self,
                               gpointer klass)
{
	ValaCodeContext* _tmp0_;
	_tmp0_ = vala_code_context_new ();
	self->context = _tmp0_;
	self->source_files = NULL;
	self->packages = NULL;
	self->defines = NULL;
}

static void
valabind_writer_finalize (ValaCodeVisitor * obj)
{
	ValabindWriter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VALABIND_WRITER, ValabindWriter);
	_g_free0 (self->modulename);
	_g_free0 (self->library);
	_g_free0 (self->pkgname);
	self->include_dirs = (_vala_array_free (self->include_dirs, _vala_array_length (self->include_dirs), (GDestroyNotify) g_free), NULL);
	self->namespaces = (_vala_array_free (self->namespaces, _vala_array_length (self->namespaces), (GDestroyNotify) g_free), NULL);
	_vala_code_context_unref0 (self->context);
	_g_free0 (self->vapidir);
	(self->source_files == NULL) ? NULL : (self->source_files = (_g_list_free__g_free0_ (self->source_files), NULL));
	(self->packages == NULL) ? NULL : (self->packages = (_g_list_free__g_free0_ (self->packages), NULL));
	(self->defines == NULL) ? NULL : (self->defines = (_g_list_free__g_free0_ (self->defines), NULL));
	VALA_CODE_VISITOR_CLASS (valabind_writer_parent_class)->finalize (obj);
}

static GType
valabind_writer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValabindWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valabind_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValabindWriter), 0, (GInstanceInitFunc) valabind_writer_instance_init, NULL };
	GType valabind_writer_type_id;
	valabind_writer_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValabindWriter", &g_define_type_info, 0);
	return valabind_writer_type_id;
}

GType
valabind_writer_get_type (void)
{
	static volatile gsize valabind_writer_type_id__once = 0;
	if (g_once_init_enter (&valabind_writer_type_id__once)) {
		GType valabind_writer_type_id;
		valabind_writer_type_id = valabind_writer_get_type_once ();
		g_once_init_leave (&valabind_writer_type_id__once, valabind_writer_type_id);
	}
	return valabind_writer_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

