/** @file
 * VirtualBox API class wrapper code for IEvent.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2025 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_EVENT

#include "EventWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(EventWrap)

//
// IEvent properties
//

STDMETHODIMP EventWrap::COMGETTER(Type)(VBoxEventType_T *aType)
{
    LogRelFlow(("{%p} %s: enter aType=%p\n", this, "Event::getType", aType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aType);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENT_GET_TYPE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getType(aType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENT_GET_TYPE_RETURN(this, hrc, 0 /*normal*/,*aType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENT_GET_TYPE_RETURN(this, hrc, 1 /*hrc exception*/,*aType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENT_GET_TYPE_RETURN(this, hrc, 9 /*unhandled exception*/,*aType);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aType=%RU32 hrc=%Rhrc\n", this, "Event::getType", *aType, hrc));
    return hrc;
}

STDMETHODIMP EventWrap::COMGETTER(Source)(IEventSource **aSource)
{
    LogRelFlow(("{%p} %s: enter aSource=%p\n", this, "Event::getSource", aSource));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSource);
        ComTypeOutConverter<IEventSource> TmpSource(aSource);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENT_GET_SOURCE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSource(TmpSource.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENT_GET_SOURCE_RETURN(this, hrc, 0 /*normal*/,(void *)TmpSource.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENT_GET_SOURCE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENT_GET_SOURCE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSource=%p hrc=%Rhrc\n", this, "Event::getSource", *aSource, hrc));
    return hrc;
}

STDMETHODIMP EventWrap::COMGETTER(Waitable)(BOOL *aWaitable)
{
    LogRelFlow(("{%p} %s: enter aWaitable=%p\n", this, "Event::getWaitable", aWaitable));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aWaitable);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENT_GET_WAITABLE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getWaitable(aWaitable);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENT_GET_WAITABLE_RETURN(this, hrc, 0 /*normal*/,*aWaitable != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENT_GET_WAITABLE_RETURN(this, hrc, 1 /*hrc exception*/,*aWaitable != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENT_GET_WAITABLE_RETURN(this, hrc, 9 /*unhandled exception*/,*aWaitable != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aWaitable=%RTbool hrc=%Rhrc\n", this, "Event::getWaitable", *aWaitable, hrc));
    return hrc;
}


//
// IEvent methods
//

STDMETHODIMP EventWrap::SetProcessed()
{
    LogRelFlow(("{%p} %s: enter\n", this, "Event::setProcessed"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENT_SETPROCESSED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setProcessed();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENT_SETPROCESSED_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENT_SETPROCESSED_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENT_SETPROCESSED_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Event::setProcessed", hrc));
    return hrc;
}

STDMETHODIMP EventWrap::WaitProcessed(LONG aTimeout,
                                      BOOL *aResult)
{
    LogRelFlow(("{%p} %s: enter aTimeout=%RI32 aResult=%p\n", this, "Event::waitProcessed", aTimeout, aResult));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aResult);


        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENT_WAITPROCESSED_ENTER(this, aTimeout);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = waitProcessed(aTimeout,
                                aResult);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENT_WAITPROCESSED_RETURN(this, hrc, 0 /*normal*/, aTimeout, *aResult != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENT_WAITPROCESSED_RETURN(this, hrc, 1 /*hrc exception*/, aTimeout, *aResult != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENT_WAITPROCESSED_RETURN(this, hrc, 9 /*unhandled exception*/, aTimeout, *aResult != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave aResult=%RTbool hrc=%Rhrc\n", this, "Event::waitProcessed", *aResult, hrc));
    return hrc;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(EventWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(EventWrap, IEvent)
#endif // VBOX_WITH_XPCOM
