/* DeviceList.c generated by valac 0.56.17, the Vala compiler
 * generated from DeviceList.vala, do not modify */

/*
 * Copyright (c) 2011-2016 elementary LLC. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street - Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "power.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	POWER_WIDGETS_DEVICE_LIST_0_PROPERTY,
	POWER_WIDGETS_DEVICE_LIST_NUM_PROPERTIES
};
static GParamSpec* power_widgets_device_list_properties[POWER_WIDGETS_DEVICE_LIST_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

static gpointer power_widgets_device_list_parent_class = NULL;

static void power_widgets_device_list_add_battery (PowerWidgetsDeviceList* self,
                                            const gchar* device_path,
                                            PowerServicesDevice* battery);
static void power_widgets_device_list_remove_battery (PowerWidgetsDeviceList* self,
                                               const gchar* device_path);
static gint power_widgets_device_list_sort_function (GtkListBoxRow* row1,
                                              GtkListBoxRow* row2,
                                              PowerWidgetsDeviceList* self);
static GObject * power_widgets_device_list_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties);
static gint _power_widgets_device_list_sort_function_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                                      GtkListBoxRow* row2,
                                                                      gpointer self);
static void _power_widgets_device_list_add_battery_power_services_device_manager_battery_registered (PowerServicesDeviceManager* _sender,
                                                                                              const gchar* device_path,
                                                                                              PowerServicesDevice* battery,
                                                                                              gpointer self);
static void _power_widgets_device_list_remove_battery_power_services_device_manager_battery_deregistered (PowerServicesDeviceManager* _sender,
                                                                                                   const gchar* device_path,
                                                                                                   gpointer self);
static void _power_widgets_device_list___lambda14_ (PowerWidgetsDeviceList* self,
                                             GtkListBoxRow* value);
static void __power_widgets_device_list___lambda14__gtk_list_box_row_activated (GtkListBox* _sender,
                                                                         GtkListBoxRow* row,
                                                                         gpointer self);
static void power_widgets_device_list_finalize (GObject * obj);
static GType power_widgets_device_list_get_type_once (void);

static void
power_widgets_device_list_add_battery (PowerWidgetsDeviceList* self,
                                       const gchar* device_path,
                                       PowerServicesDevice* battery)
{
	PowerWidgetsDeviceRow* device_row = NULL;
	PowerWidgetsDeviceRow* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMap* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device_path != NULL);
	g_return_if_fail (battery != NULL);
	_tmp0_ = power_widgets_device_row_new (battery);
	g_object_ref_sink (_tmp0_);
	device_row = _tmp0_;
	_tmp1_ = self->entries;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp1_, device_path, device_row);
	_tmp2_ = self->path_entries;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp2_, (GtkListBoxRow*) device_row, device_path);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) device_row);
	gtk_widget_show_all ((GtkWidget*) self);
	gtk_list_box_invalidate_sort ((GtkListBox*) self);
	_g_object_unref0 (device_row);
}

static void
power_widgets_device_list_remove_battery (PowerWidgetsDeviceList* self,
                                          const gchar* device_path)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	gpointer _tmp2_;
	PowerWidgetsDeviceRow* _tmp3_;
	GeeHashMap* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device_path != NULL);
	_tmp0_ = self->entries;
	if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, device_path)) {
		return;
	}
	_tmp1_ = self->entries;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, device_path);
	_tmp3_ = (PowerWidgetsDeviceRow*) _tmp2_;
	gtk_widget_destroy ((GtkWidget*) _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = self->entries;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp4_, device_path, NULL);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gint
power_widgets_device_list_sort_function (GtkListBoxRow* row1,
                                         GtkListBoxRow* row2,
                                         PowerWidgetsDeviceList* self)
{
	PowerServicesDevice* battery1 = NULL;
	PowerServicesDevice* _tmp0_;
	PowerServicesDevice* _tmp1_;
	PowerServicesDevice* _tmp2_;
	PowerServicesDevice* battery2 = NULL;
	PowerServicesDevice* _tmp3_;
	PowerServicesDevice* _tmp4_;
	PowerServicesDevice* _tmp5_;
	PowerServicesDevice* _tmp6_;
	PowerServicesDeviceType _tmp7_;
	PowerServicesDeviceType _tmp8_;
	PowerServicesDevice* _tmp9_;
	PowerServicesDeviceType _tmp10_;
	PowerServicesDeviceType _tmp11_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (row1 != NULL, 0);
	g_return_val_if_fail (row2 != NULL, 0);
	_tmp0_ = power_widgets_device_row_get_battery (G_TYPE_CHECK_INSTANCE_CAST (row1, POWER_WIDGETS_TYPE_DEVICE_ROW, PowerWidgetsDeviceRow));
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	battery1 = _tmp2_;
	_tmp3_ = power_widgets_device_row_get_battery (G_TYPE_CHECK_INSTANCE_CAST (row2, POWER_WIDGETS_TYPE_DEVICE_ROW, PowerWidgetsDeviceRow));
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	battery2 = _tmp5_;
	_tmp6_ = battery1;
	_tmp7_ = power_services_device_get_device_type (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = battery2;
	_tmp10_ = power_services_device_get_device_type (_tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp8_ == _tmp11_) {
		result = 0;
		_g_object_unref0 (battery2);
		_g_object_unref0 (battery1);
		return result;
	} else {
		PowerServicesDevice* _tmp12_;
		PowerServicesDeviceType _tmp13_;
		PowerServicesDeviceType _tmp14_;
		_tmp12_ = battery1;
		_tmp13_ = power_services_device_get_device_type (_tmp12_);
		_tmp14_ = _tmp13_;
		if (_tmp14_ == POWER_SERVICES_DEVICE_TYPE_BATTERY) {
			result = -1;
			_g_object_unref0 (battery2);
			_g_object_unref0 (battery1);
			return result;
		} else {
			result = 1;
			_g_object_unref0 (battery2);
			_g_object_unref0 (battery1);
			return result;
		}
	}
}

PowerWidgetsDeviceList*
power_widgets_device_list_construct (GType object_type)
{
	PowerWidgetsDeviceList * self = NULL;
	self = (PowerWidgetsDeviceList*) g_object_new (object_type, NULL);
	return self;
}

PowerWidgetsDeviceList*
power_widgets_device_list_new (void)
{
	return power_widgets_device_list_construct (POWER_WIDGETS_TYPE_DEVICE_LIST);
}

static gint
_power_widgets_device_list_sort_function_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                                 GtkListBoxRow* row2,
                                                                 gpointer self)
{
	gint result;
	result = power_widgets_device_list_sort_function (row1, row2, (PowerWidgetsDeviceList*) self);
	return result;
}

static void
_power_widgets_device_list_add_battery_power_services_device_manager_battery_registered (PowerServicesDeviceManager* _sender,
                                                                                         const gchar* device_path,
                                                                                         PowerServicesDevice* battery,
                                                                                         gpointer self)
{
	power_widgets_device_list_add_battery ((PowerWidgetsDeviceList*) self, device_path, battery);
}

static void
_power_widgets_device_list_remove_battery_power_services_device_manager_battery_deregistered (PowerServicesDeviceManager* _sender,
                                                                                              const gchar* device_path,
                                                                                              gpointer self)
{
	power_widgets_device_list_remove_battery ((PowerWidgetsDeviceList*) self, device_path);
}

static void
_power_widgets_device_list___lambda14_ (PowerWidgetsDeviceList* self,
                                        GtkListBoxRow* value)
{
	gchar* device_path = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (value != NULL);
	_tmp0_ = self->path_entries;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, value);
	device_path = (gchar*) _tmp1_;
	{
		GAppInfo* statistics_app = NULL;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GAppInfo* _tmp5_;
		GAppInfo* _tmp6_;
		GAppInfo* _tmp7_;
		GtkPopover* popover = NULL;
		GtkWidget* _tmp8_;
		GtkPopover* _tmp9_;
		GtkPopover* _tmp10_;
		_tmp2_ = device_path;
		_tmp3_ = g_strconcat ("gnome-power-statistics --device ", _tmp2_, NULL);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_app_info_create_from_commandline (_tmp4_, "", G_APP_INFO_CREATE_NONE, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		statistics_app = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp7_ = statistics_app;
		g_app_info_launch (_tmp7_, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (statistics_app);
			goto __catch0_g_error;
		}
		_tmp8_ = gtk_widget_get_ancestor ((GtkWidget*) self, gtk_popover_get_type ());
		_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_popover_get_type (), GtkPopover));
		popover = _tmp9_;
		_tmp10_ = popover;
		gtk_popover_popdown (_tmp10_);
		_g_object_unref0 (popover);
		_g_object_unref0 (statistics_app);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_print ("Error opening Gnome Power Statistics: %s\n", _tmp12_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (device_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (device_path);
}

static void
__power_widgets_device_list___lambda14__gtk_list_box_row_activated (GtkListBox* _sender,
                                                                    GtkListBoxRow* row,
                                                                    gpointer self)
{
	_power_widgets_device_list___lambda14_ ((PowerWidgetsDeviceList*) self, row);
}

static GObject *
power_widgets_device_list_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PowerWidgetsDeviceList * self;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	PowerServicesDeviceManager* dm = NULL;
	PowerServicesDeviceManager* _tmp2_;
	PowerServicesDeviceManager* _tmp3_;
	PowerServicesDeviceManager* _tmp4_;
	PowerServicesDeviceManager* _tmp5_;
	PowerServicesDeviceManager* _tmp6_;
	parent_class = G_OBJECT_CLASS (power_widgets_device_list_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POWER_WIDGETS_TYPE_DEVICE_LIST, PowerWidgetsDeviceList);
	gtk_list_box_set_selection_mode ((GtkListBox*) self, GTK_SELECTION_NONE);
	gtk_list_box_set_sort_func ((GtkListBox*) self, _power_widgets_device_list_sort_function_gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, POWER_WIDGETS_TYPE_DEVICE_ROW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->entries);
	self->entries = _tmp0_;
	_tmp1_ = gee_hash_map_new (gtk_list_box_row_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->path_entries);
	self->path_entries = _tmp1_;
	_tmp2_ = power_services_device_manager_get_default ();
	_tmp3_ = _g_object_ref0 (_tmp2_);
	dm = _tmp3_;
	_tmp4_ = dm;
	g_signal_connect_object (_tmp4_, "battery-registered", (GCallback) _power_widgets_device_list_add_battery_power_services_device_manager_battery_registered, self, 0);
	_tmp5_ = dm;
	g_signal_connect_object (_tmp5_, "battery-deregistered", (GCallback) _power_widgets_device_list_remove_battery_power_services_device_manager_battery_deregistered, self, 0);
	_tmp6_ = dm;
	power_services_device_manager_read_devices (_tmp6_);
	g_signal_connect_object ((GtkListBox*) self, "row-activated", (GCallback) __power_widgets_device_list___lambda14__gtk_list_box_row_activated, self, 0);
	_g_object_unref0 (dm);
	return obj;
}

static void
power_widgets_device_list_class_init (PowerWidgetsDeviceListClass * klass,
                                      gpointer klass_data)
{
	power_widgets_device_list_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructor = power_widgets_device_list_constructor;
	G_OBJECT_CLASS (klass)->finalize = power_widgets_device_list_finalize;
}

static void
power_widgets_device_list_instance_init (PowerWidgetsDeviceList * self,
                                         gpointer klass)
{
}

static void
power_widgets_device_list_finalize (GObject * obj)
{
	PowerWidgetsDeviceList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POWER_WIDGETS_TYPE_DEVICE_LIST, PowerWidgetsDeviceList);
	_g_object_unref0 (self->entries);
	_g_object_unref0 (self->path_entries);
	G_OBJECT_CLASS (power_widgets_device_list_parent_class)->finalize (obj);
}

static GType
power_widgets_device_list_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PowerWidgetsDeviceListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) power_widgets_device_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PowerWidgetsDeviceList), 0, (GInstanceInitFunc) power_widgets_device_list_instance_init, NULL };
	GType power_widgets_device_list_type_id;
	power_widgets_device_list_type_id = g_type_register_static (gtk_list_box_get_type (), "PowerWidgetsDeviceList", &g_define_type_info, 0);
	return power_widgets_device_list_type_id;
}

GType
power_widgets_device_list_get_type (void)
{
	static volatile gsize power_widgets_device_list_type_id__once = 0;
	if (g_once_init_enter (&power_widgets_device_list_type_id__once)) {
		GType power_widgets_device_list_type_id;
		power_widgets_device_list_type_id = power_widgets_device_list_get_type_once ();
		g_once_init_leave (&power_widgets_device_list_type_id__once, power_widgets_device_list_type_id);
	}
	return power_widgets_device_list_type_id__once;
}

