/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.jdesktop.swingx.decorator.AbstractHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;

public class AlignmentHighlighter
extends AbstractHighlighter {
    private static final int defaultAlignment = 10;
    private int alignment;

    public AlignmentHighlighter() {
        this(10);
    }

    public AlignmentHighlighter(int alignment) {
        this(null, alignment);
    }

    public AlignmentHighlighter(HighlightPredicate predicate) {
        this(predicate, 10);
    }

    public AlignmentHighlighter(HighlightPredicate predicate, int alignment) {
        super(predicate);
        this.alignment = this.checkHorizontalAlignment(alignment);
    }

    public int getHorizontalAlignment() {
        return this.alignment;
    }

    public void setHorizontalAlignment(int alignment) {
        if (this.getHorizontalAlignment() == alignment) {
            return;
        }
        this.alignment = this.checkHorizontalAlignment(alignment);
        this.fireStateChanged();
    }

    private int checkHorizontalAlignment(int alignment) {
        if (alignment == 2 || alignment == 0 || alignment == 4 || alignment == 10 || alignment == 11) {
            return alignment;
        }
        throw new IllegalArgumentException("invalid horizontal alignment, expected one of 2 / 0 / 4 / 10 / 11 but was: " + alignment);
    }

    protected Component doHighlight(Component renderer, ComponentAdapter adapter) {
        if (renderer instanceof JLabel) {
            ((JLabel)renderer).setHorizontalAlignment(this.getHorizontalAlignment());
        } else if (renderer instanceof AbstractButton) {
            ((AbstractButton)renderer).setHorizontalAlignment(this.getHorizontalAlignment());
        } else {
            ((JTextField)renderer).setHorizontalAlignment(this.getHorizontalAlignment());
        }
        return renderer;
    }

    protected boolean canHighlight(Component component, ComponentAdapter adapter) {
        return component instanceof JLabel || component instanceof AbstractButton || component instanceof JTextField;
    }
}

