/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.control;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.common.networking.MessageHandler;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.control.FreeColServerHolder;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;

public final class ServerInputHandler
extends FreeColServerHolder
implements MessageHandler {
    private static final Logger logger = Logger.getLogger(ServerInputHandler.class.getName());

    public ServerInputHandler(FreeColServer freeColServer) {
        super(freeColServer);
    }

    @Override
    public Message handle(Connection connection, Message message) throws FreeColException {
        FreeColServer freeColServer = this.getFreeColServer();
        ServerPlayer serverPlayer = freeColServer.getPlayer(connection);
        if (serverPlayer == null) {
            throw new RuntimeException("No server player available: " + message);
        }
        ServerGame game = freeColServer.getGame();
        boolean current = message.currentPlayerMessage();
        ChangeSet cs = current && (game == null || serverPlayer != game.getCurrentPlayer()) ? serverPlayer.clientError("Received: " + message.getType() + " out of turn from player: " + serverPlayer.getNation()) : message.serverHandler(freeColServer, serverPlayer);
        return cs == null ? null : cs.build(serverPlayer);
    }

    @Override
    public Message read(Connection connection) throws FreeColException, XMLStreamException {
        return Message.read(this.getGame(), connection.getFreeColXMLReader());
    }
}

