#############################################################################
##
#W  strong.tst         GAP4 package IBNP         Gareth Evans & Chris Wensley
##

gap> START_TEST( "strong.tst" );
gap> ibnp_infolevel_saved := InfoLevel( InfoIBNP );; 
gap> SetInfoLevel( InfoIBNP, 0 );; 

gap> A3 := Algebra3IBNP;;
gap> a:=A3.1;;  b:=A3.2;; c:=A3.3;;
gap> ord := NCMonomialLeftLengthLexicographicOrdering( A3 );;

gap> L3 := [ [ [ [3,3,3], [2] ], [1,-1] ],
>          [ [ [1,1,1], [2] ], [1,-1] ], 
>          [ [ [3,2], [2,3] ], [1,-1] ],
>          [ [ [2,1], [1,2] ], [1,-1] ],
>          [ [ [3,1], [1,3] ], [1,-1] ] ];;
gap> L3 := List( L3, p -> CleanNP(p) );;
gap> PrintNPList( L3 );
 c^3 - b 
 a^3 - b 
 cb - bc 
 ba - ab 
 ca - ac 

gap> NoncommutativeDivision := "LeftOverlap";;
gap> drec := DivisionRecordNP( A3, L3, ord );
rec( div := "LeftOverlap", 
  mvars := [ [ [ 1 .. 3 ], [ 1 .. 3 ], [ 1 .. 3 ], [ 1 .. 3 ], [ 1 .. 3 ] ], 
      [ [  ], [ 2, 3 ], [ 2, 3 ], [ 2, 3 ], [ 2, 3 ] ] ], 
  polys := [ [ [ [ 3, 3, 3 ], [ 2 ] ], [ 1, -1 ] ], 
      [ [ [ 1, 1, 1 ], [ 2 ] ], [ 1, -1 ] ], 
      [ [ [ 3, 2 ], [ 2, 3 ] ], [ 1, -1 ] ], 
      [ [ [ 2, 1 ], [ 1, 2 ] ], [ 1, -1 ] ], 
      [ [ [ 3, 1 ], [ 1, 3 ] ], [ 1, -1 ] ] ] )

gap> mons := List( drec.polys, p -> p[1][1] );
[ [ 3, 3, 3 ], [ 1, 1, 1 ], [ 3, 2 ], [ 2, 1 ], [ 3, 1 ] ]
gap> vars := List( mons, m -> Set(m) );
[ [ 3 ], [ 1 ], [ 2, 3 ], [ 1, 2 ], [ 1, 3 ] ]
gap> rvars := drec.mvars[2];
[ [  ], [ 2, 3 ], [ 2, 3 ], [ 2, 3 ], [ 2, 3 ] ]

gap> ibas := InvolutiveBasisNP( A3, L3, ord );
rec( div := "LeftOverlap", 
  mvars := 
    [ 
      [ [ 1 .. 3 ], [ 1 .. 3 ], [ 1 .. 3 ], [ 1 .. 3 ], [ 1 .. 3 ], 
          [ 1 .. 3 ], [ 1 .. 3 ] ], 
      [ [  ], [ 2, 3 ], [ 2, 3 ], [ 2, 3 ], [ 2, 3 ], [ 2, 3 ], [ 2, 3 ] ] ], 
  polys := [ [ [ [ 3, 3, 3 ], [ 2 ] ], [ 1, -1 ] ], 
      [ [ [ 3, 1, 1 ], [ 1, 1, 3 ] ], [ 1, -1 ] ], 
      [ [ [ 2, 1, 1 ], [ 1, 1, 2 ] ], [ 1, -1 ] ], 
      [ [ [ 1, 1, 1 ], [ 2 ] ], [ 1, -1 ] ], 
      [ [ [ 3, 2 ], [ 2, 3 ] ], [ 1, -1 ] ], 
      [ [ [ 3, 1 ], [ 1, 3 ] ], [ 1, -1 ] ], 
      [ [ [ 2, 1 ], [ 1, 2 ] ], [ 1, -1 ] ] ] )
gap> PrintNPList( ibas.polys );;
 c^3 - b 
 ca^2 - a^2c 
 ba^2 - a^2b 
 a^3 - b 
 cb - bc 
 ca - ac 
 ba - ab 

gap> NoncommutativeDivision := "RightOverlap";;
gap> rdrec := DivisionRecordNP( A3, L3, ord );
rec( div := "RightOverlap", 
  mvars := [ [ [ 1, 2 ], [  ], [ 1, 2 ], [ 1, 2 ], [ 1, 2 ] ], 
      [ [ 1 .. 3 ], [ 1 .. 3 ], [ 1 .. 3 ], [ 1 .. 3 ], [ 1 .. 3 ] ] ], 
  polys := [ [ [ [ 3, 3, 3 ], [ 2 ] ], [ 1, -1 ] ], 
      [ [ [ 1, 1, 1 ], [ 2 ] ], [ 1, -1 ] ], 
      [ [ [ 3, 2 ], [ 2, 3 ] ], [ 1, -1 ] ], 
      [ [ [ 2, 1 ], [ 1, 2 ] ], [ 1, -1 ] ], 
      [ [ [ 3, 1 ], [ 1, 3 ] ], [ 1, -1 ] ] ] )

gap> ribas := InvolutiveBasisNP( A3, L3, ord );
rec( div := "RightOverlap", 
  mvars := 
    [ [ [ 1, 2 ], [ 1, 2 ], [ 1, 2 ], [  ], [ 1, 2 ], [ 1, 2 ], [ 1, 2 ] ], 
      [ [ 1 .. 3 ], [ 1 .. 3 ], [ 1 .. 3 ], [ 1 .. 3 ], [ 1 .. 3 ], 
          [ 1 .. 3 ], [ 1 .. 3 ] ] ], 
  polys := [ [ [ [ 3, 3, 3 ], [ 2 ] ], [ 1, -1 ] ], 
      [ [ [ 3, 3, 2 ], [ 2, 3, 3 ] ], [ 1, -1 ] ], 
      [ [ [ 3, 3, 1 ], [ 1, 3, 3 ] ], [ 1, -1 ] ], 
      [ [ [ 1, 1, 1 ], [ 2 ] ], [ 1, -1 ] ], 
      [ [ [ 3, 2 ], [ 2, 3 ] ], [ 1, -1 ] ], 
      [ [ [ 3, 1 ], [ 1, 3 ] ], [ 1, -1 ] ], 
      [ [ [ 2, 1 ], [ 1, 2 ] ], [ 1, -1 ] ] ] )
gap> PrintNPList( ribas.polys );;
 c^3 - b 
 c^2b - bc^2 
 c^2a - ac^2 
 a^3 - b 
 cb - bc 
 ca - ac 
 ba - ab 

gap> NoncommutativeDivision := "StrongLeftOverlap";;
gap> srec := DivisionRecordNP( A3, L3, ord );
rec( div := "StrongLeftOverlap", 
  mvars := [ [ [ 1 .. 3 ], [ 1 .. 3 ], [ 1 .. 3 ], [ 1 .. 3 ], [ 1 .. 3 ] ], 
      [ [  ], [ 2 ], [ 2 ], [ 2 ], [ 2 ] ] ], 
  polys := [ [ [ [ 3, 3, 3 ], [ 2 ] ], [ 1, -1 ] ], 
      [ [ [ 1, 1, 1 ], [ 2 ] ], [ 1, -1 ] ], 
      [ [ [ 3, 2 ], [ 2, 3 ] ], [ 1, -1 ] ], 
      [ [ [ 2, 1 ], [ 1, 2 ] ], [ 1, -1 ] ], 
      [ [ [ 3, 1 ], [ 1, 3 ] ], [ 1, -1 ] ] ] )

gap> sbas := InvolutiveBasisNP( A3, L3, ord );
rec( div := "StrongLeftOverlap", 
  mvars := 
    [ 
      [ [ 1 .. 3 ], [ 1 .. 3 ], [ 1 .. 3 ], [ 1 .. 3 ], [ 1 .. 3 ], 
          [ 1 .. 3 ], [ 1 .. 3 ], [ 1 .. 3 ], [ 1 .. 3 ], [ 1 .. 3 ], 
          [ 1 .. 3 ], [ 1 .. 3 ], [ 1 .. 3 ], [ 1 .. 3 ], [ 1 .. 3 ], 
          [ 1 .. 3 ], [ 1 .. 3 ], [ 1 .. 3 ], [ 1 .. 3 ] ], 
      [ [  ], [  ], [  ], [  ], [  ], [  ], [  ], [  ], [  ], [  ], [  ], 
          [  ], [ 2 ], [  ], [ 2 ], [ 2 ], [ 2 ], [ 2 ], [ 2 ] ] ], 
  polys := [ [ [ [ 3, 1, 1, 3, 3 ], [ 1, 1, 2 ] ], [ 1, -1 ] ], 
      [ [ [ 2, 1, 1, 3, 3 ], [ 1, 1, 2, 3, 3 ] ], [ 1, -1 ] ], 
      [ [ [ 1, 1, 1, 3, 3 ], [ 2, 3, 3 ] ], [ 1, -1 ] ], 
      [ [ [ 3, 2, 3, 3 ], [ 2, 2 ] ], [ 1, -1 ] ], 
      [ [ [ 3, 1, 3, 3 ], [ 1, 2 ] ], [ 1, -1 ] ], 
      [ [ [ 3, 1, 1, 3 ], [ 1, 1, 3, 3 ] ], [ 1, -1 ] ], 
      [ [ [ 2, 1, 3, 3 ], [ 1, 2, 3, 3 ] ], [ 1, -1 ] ], 
      [ [ [ 2, 1, 1, 3 ], [ 1, 1, 2, 3 ] ], [ 1, -1 ] ], 
      [ [ [ 1, 1, 1, 3 ], [ 2, 3 ] ], [ 1, -1 ] ], 
      [ [ [ 3, 3, 3 ], [ 2 ] ], [ 1, -1 ] ], 
      [ [ [ 3, 2, 3 ], [ 2, 3, 3 ] ], [ 1, -1 ] ], 
      [ [ [ 3, 1, 3 ], [ 1, 3, 3 ] ], [ 1, -1 ] ], 
      [ [ [ 3, 1, 1 ], [ 1, 1, 3 ] ], [ 1, -1 ] ], 
      [ [ [ 2, 1, 3 ], [ 1, 2, 3 ] ], [ 1, -1 ] ], 
      [ [ [ 2, 1, 1 ], [ 1, 1, 2 ] ], [ 1, -1 ] ], 
      [ [ [ 1, 1, 1 ], [ 2 ] ], [ 1, -1 ] ], 
      [ [ [ 3, 2 ], [ 2, 3 ] ], [ 1, -1 ] ], 
      [ [ [ 3, 1 ], [ 1, 3 ] ], [ 1, -1 ] ], 
      [ [ [ 2, 1 ], [ 1, 2 ] ], [ 1, -1 ] ] ] )
gap> PrintNPList( sbas.polys );
 ca^2c^2 - a^2b 
 ba^2c^2 - a^2bc^2 
 a^3c^2 - bc^2 
 cbc^2 - b^2 
 cac^2 - ab 
 ca^2c - a^2c^2 
 bac^2 - abc^2 
 ba^2c - a^2bc 
 a^3c - bc 
 c^3 - b 
 cbc - bc^2 
 cac - ac^2 
 ca^2 - a^2c 
 bac - abc 
 ba^2 - a^2b 
 a^3 - b 
 cb - bc 
 ca - ac 
 ba - ab 

gap> NoncommutativeDivision := "StrongRightOverlap";;
gap> rsrec := DivisionRecordNP( A3, L3, ord );
rec( div := "StrongRightOverlap", 
  mvars := [ [ [ 2 ], [  ], [ 2 ], [ 2 ], [ 2 ] ], 
      [ [ 1 .. 3 ], [ 1 .. 3 ], [ 1 .. 3 ], [ 1 .. 3 ], [ 1 .. 3 ] ] ], 
  polys := [ [ [ [ 3, 3, 3 ], [ 2 ] ], [ 1, -1 ] ], 
      [ [ [ 1, 1, 1 ], [ 2 ] ], [ 1, -1 ] ], 
      [ [ [ 3, 2 ], [ 2, 3 ] ], [ 1, -1 ] ], 
      [ [ [ 2, 1 ], [ 1, 2 ] ], [ 1, -1 ] ], 
      [ [ [ 3, 1 ], [ 1, 3 ] ], [ 1, -1 ] ] ] )

gap> rsbas := InvolutiveBasisNP( A3, L3, ord );
rec( div := "StrongRightOverlap", 
  mvars := 
    [ [ [  ], [  ], [  ], [  ], [  ], [  ], [  ], [  ], [  ], [ 2 ], [ 2 ], 
          [ 2 ], [  ], [  ], [  ], [  ], [ 2 ], [ 2 ], [ 2 ] ], 
      [ [ 1 .. 3 ], [ 1 .. 3 ], [ 1 .. 3 ], [ 1 .. 3 ], [ 1 .. 3 ], 
          [ 1 .. 3 ], [ 1 .. 3 ], [ 1 .. 3 ], [ 1 .. 3 ], [ 1 .. 3 ], 
          [ 1 .. 3 ], [ 1 .. 3 ], [ 1 .. 3 ], [ 1 .. 3 ], [ 1 .. 3 ], 
          [ 1 .. 3 ], [ 1 .. 3 ], [ 1 .. 3 ], [ 1 .. 3 ] ] ], 
  polys := [ [ [ [ 1, 1, 3, 3, 3 ], [ 1, 1, 2 ] ], [ 1, -1 ] ], 
      [ [ [ 1, 1, 3, 3, 2 ], [ 1, 1, 2, 3, 3 ] ], [ 1, -1 ] ], 
      [ [ [ 1, 1, 3, 3, 1 ], [ 2, 3, 3 ] ], [ 1, -1 ] ], 
      [ [ [ 1, 3, 3, 3 ], [ 1, 2 ] ], [ 1, -1 ] ], 
      [ [ [ 1, 3, 3, 2 ], [ 1, 2, 3, 3 ] ], [ 1, -1 ] ], 
      [ [ [ 1, 3, 3, 1 ], [ 1, 1, 3, 3 ] ], [ 1, -1 ] ], 
      [ [ [ 1, 1, 3, 2 ], [ 1, 1, 2, 3 ] ], [ 1, -1 ] ], 
      [ [ [ 1, 1, 3, 1 ], [ 2, 3 ] ], [ 1, -1 ] ], 
      [ [ [ 1, 1, 2, 1 ], [ 2, 2 ] ], [ 1, -1 ] ], 
      [ [ [ 3, 3, 3 ], [ 2 ] ], [ 1, -1 ] ], 
      [ [ [ 3, 3, 2 ], [ 2, 3, 3 ] ], [ 1, -1 ] ], 
      [ [ [ 3, 3, 1 ], [ 1, 3, 3 ] ], [ 1, -1 ] ], 
      [ [ [ 1, 3, 2 ], [ 1, 2, 3 ] ], [ 1, -1 ] ], 
      [ [ [ 1, 3, 1 ], [ 1, 1, 3 ] ], [ 1, -1 ] ], 
      [ [ [ 1, 2, 1 ], [ 1, 1, 2 ] ], [ 1, -1 ] ], 
      [ [ [ 1, 1, 1 ], [ 2 ] ], [ 1, -1 ] ], 
      [ [ [ 3, 2 ], [ 2, 3 ] ], [ 1, -1 ] ], 
      [ [ [ 3, 1 ], [ 1, 3 ] ], [ 1, -1 ] ], 
      [ [ [ 2, 1 ], [ 1, 2 ] ], [ 1, -1 ] ] ] )
gap> PrintNPList( rsbas.polys );
 a^2c^3 - a^2b 
 a^2c^2b - a^2bc^2 
 a^2c^2a - bc^2 
 ac^3 - ab 
 ac^2b - abc^2 
 ac^2a - a^2c^2 
 a^2cb - a^2bc 
 a^2ca - bc 
 a^2ba - b^2 
 c^3 - b 
 c^2b - bc^2 
 c^2a - ac^2 
 acb - abc 
 aca - a^2c 
 aba - a^2b 
 a^3 - b 
 cb - bc 
 ca - ac 
 ba - ab 

gap> SetInfoLevel( InfoIBNP, ibnp_infolevel_saved );; 
gap> STOP_TEST( "strong.tst", 10000 );

#############################################################################
##
#E  strong.tst . . . . . . . . . . . . . . . . . . . . . . . . . . ends here
