/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.math.geom;

import com.jogamp.math.FloatUtil;
import com.jogamp.math.Matrix4f;
import com.jogamp.math.Quaternion;
import com.jogamp.math.Ray;
import com.jogamp.math.Recti;
import com.jogamp.math.Vec3f;
import com.jogamp.math.geom.plane.AffineTransform;

public final class AABBox {
    private static final boolean DEBUG = FloatUtil.DEBUG;
    private final Vec3f lo = new Vec3f();
    private final Vec3f hi = new Vec3f();
    private final Vec3f center = new Vec3f();

    public AABBox() {
        this.reset();
    }

    public AABBox(AABBox aABBox) {
        this.copy(aABBox);
    }

    public AABBox(float f, float f2, float f3, float f4, float f5, float f6) {
        this.setSize(f, f2, f3, f4, f5, f6);
    }

    public AABBox(float[] fArray, float[] fArray2) {
        this.setSize(fArray, fArray2);
    }

    public AABBox(Vec3f vec3f, Vec3f vec3f2) {
        this.setSize(vec3f, vec3f2);
    }

    public final AABBox reset() {
        this.setLow(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        this.setHigh(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
        this.center.set(0.0f, 0.0f, 0.0f);
        return this;
    }

    public final Vec3f getHigh() {
        return this.hi;
    }

    private final void setHigh(float f, float f2, float f3) {
        this.hi.set(f, f2, f3);
    }

    public final Vec3f getLow() {
        return this.lo;
    }

    private final void setLow(float f, float f2, float f3) {
        this.lo.set(f, f2, f3);
    }

    private final void computeCenter() {
        this.center.set(this.hi).add(this.lo).scale(0.5f);
    }

    public final AABBox copy(AABBox aABBox) {
        this.lo.set(aABBox.lo);
        this.hi.set(aABBox.hi);
        this.center.set(aABBox.center);
        return this;
    }

    public final AABBox setSize(float[] fArray, float[] fArray2) {
        return this.setSize(fArray[0], fArray[1], fArray[2], fArray2[0], fArray2[1], fArray2[2]);
    }

    public final AABBox setSize(float f, float f2, float f3, float f4, float f5, float f6) {
        this.lo.set(f, f2, f3);
        this.hi.set(f4, f5, f6);
        this.computeCenter();
        return this;
    }

    public final AABBox setSize(Vec3f vec3f, Vec3f vec3f2) {
        this.lo.set(vec3f);
        this.hi.set(vec3f2);
        this.computeCenter();
        return this;
    }

    public final AABBox resizeWidth(float f, float f2) {
        boolean bl = false;
        if (!FloatUtil.isZero(f)) {
            this.lo.setX(this.lo.x() - f);
            bl = true;
        }
        if (!FloatUtil.isZero(f2)) {
            this.hi.setX(this.hi.x() + f2);
            bl = true;
        }
        if (bl) {
            this.computeCenter();
        }
        return this;
    }

    public final AABBox resizeHeight(float f, float f2) {
        boolean bl = false;
        if (!FloatUtil.isZero(f)) {
            this.lo.setY(this.lo.y() - f);
            bl = true;
        }
        if (!FloatUtil.isZero(f2)) {
            this.hi.setY(this.hi.y() + f2);
            bl = true;
        }
        if (bl) {
            this.computeCenter();
        }
        return this;
    }

    public final AABBox set(AABBox aABBox) {
        this.lo.set(aABBox.lo);
        this.hi.set(aABBox.hi);
        this.center.set(aABBox.center);
        return this;
    }

    public final AABBox resize(AABBox aABBox) {
        Vec3f vec3f = aABBox.getLow();
        Vec3f vec3f2 = aABBox.getHigh();
        if (vec3f.x() < this.lo.x()) {
            this.lo.setX(vec3f.x());
        }
        if (vec3f.y() < this.lo.y()) {
            this.lo.setY(vec3f.y());
        }
        if (vec3f.z() < this.lo.z()) {
            this.lo.setZ(vec3f.z());
        }
        if (vec3f2.x() > this.hi.x()) {
            this.hi.setX(vec3f2.x());
        }
        if (vec3f2.y() > this.hi.y()) {
            this.hi.setY(vec3f2.y());
        }
        if (vec3f2.z() > this.hi.z()) {
            this.hi.setZ(vec3f2.z());
        }
        this.computeCenter();
        return this;
    }

    public final AABBox resize(AABBox aABBox, AffineTransform affineTransform, Vec3f vec3f) {
        Vec3f vec3f2 = affineTransform.transform(aABBox.getLow(), vec3f);
        if (vec3f2.x() < this.lo.x()) {
            this.lo.setX(vec3f2.x());
        }
        if (vec3f2.y() < this.lo.y()) {
            this.lo.setY(vec3f2.y());
        }
        if (vec3f2.z() < this.lo.z()) {
            this.lo.setZ(vec3f2.z());
        }
        if ((vec3f2 = affineTransform.transform(aABBox.getHigh(), vec3f)).x() > this.hi.x()) {
            this.hi.setX(vec3f2.x());
        }
        if (vec3f2.y() > this.hi.y()) {
            this.hi.setY(vec3f2.y());
        }
        if (vec3f2.z() > this.hi.z()) {
            this.hi.setZ(vec3f2.z());
        }
        this.computeCenter();
        return this;
    }

    public final AABBox resize(float f, float f2, float f3) {
        if (f < this.lo.x()) {
            this.lo.setX(f);
        }
        if (f2 < this.lo.y()) {
            this.lo.setY(f2);
        }
        if (f3 < this.lo.z()) {
            this.lo.setZ(f3);
        }
        if (f > this.hi.x()) {
            this.hi.setX(f);
        }
        if (f2 > this.hi.y()) {
            this.hi.setY(f2);
        }
        if (f3 > this.hi.z()) {
            this.hi.setZ(f3);
        }
        this.computeCenter();
        return this;
    }

    public final AABBox resize(float[] fArray, int n) {
        return this.resize(fArray[0 + n], fArray[1 + n], fArray[2 + n]);
    }

    public final AABBox resize(float[] fArray) {
        return this.resize(fArray[0], fArray[1], fArray[2]);
    }

    public final AABBox resize(Vec3f vec3f) {
        return this.resize(vec3f.x(), vec3f.y(), vec3f.z());
    }

    public final boolean contains(float f, float f2) {
        return this.lo.x() <= f && f <= this.hi.x() && this.lo.y() <= f2 && f2 <= this.hi.y();
    }

    public final boolean contains(float f, float f2, float f3) {
        return this.lo.x() <= f && f <= this.hi.x() && this.lo.y() <= f2 && f2 <= this.hi.y() && this.lo.z() <= f3 && f3 <= this.hi.z();
    }

    public final boolean intersects(AABBox aABBox) {
        return Math.max(this.lo.x(), aABBox.lo.x()) <= Math.min(this.hi.x(), aABBox.hi.x()) && Math.max(this.lo.y(), aABBox.lo.y()) <= Math.min(this.hi.y(), aABBox.hi.y()) && Math.max(this.lo.z(), aABBox.lo.z()) <= Math.min(this.hi.z(), aABBox.hi.z());
    }

    public final boolean contains(AABBox aABBox) {
        return this.hi.x() >= aABBox.hi.x() && this.hi.y() >= aABBox.hi.y() && this.hi.z() >= aABBox.hi.z() && this.lo.x() <= aABBox.lo.x() && this.lo.y() <= aABBox.lo.y() && this.lo.z() <= aABBox.lo.z();
    }

    public final boolean intersects2DRegion(float f, float f2, float f3, float f4) {
        if (f3 <= 0.0f || f4 <= 0.0f) {
            return false;
        }
        float f5 = this.getWidth();
        float f6 = this.getHeight();
        if (f5 <= 0.0f || f6 <= 0.0f) {
            return false;
        }
        float f7 = this.getMinX();
        float f8 = this.getMinY();
        return f >= f7 && f2 >= f8 && f + f3 <= f7 + f5 && f2 + f4 <= f8 + f6;
    }

    public final boolean intersectsRay(Ray ray) {
        float f = ray.dir.x();
        float f2 = ray.orig.x() - this.center.x();
        float f3 = this.hi.x() - this.center.x();
        if (Math.abs(f2) > f3 && f2 * f >= 0.0f) {
            return false;
        }
        float f4 = ray.dir.y();
        float f5 = ray.orig.y() - this.center.y();
        float f6 = this.hi.y() - this.center.y();
        if (Math.abs(f5) > f6 && f5 * f4 >= 0.0f) {
            return false;
        }
        float f7 = ray.dir.z();
        float f8 = ray.orig.z() - this.center.z();
        float f9 = this.hi.z() - this.center.z();
        if (Math.abs(f8) > f9 && f8 * f7 >= 0.0f) {
            return false;
        }
        float f10 = Math.abs(f4);
        float f11 = Math.abs(f7);
        float f12 = f4 * f8 - f7 * f5;
        if (Math.abs(f12) > f6 * f11 + f9 * f10) {
            return false;
        }
        float f13 = Math.abs(f);
        f12 = f7 * f2 - f * f8;
        if (Math.abs(f12) > f3 * f11 + f9 * f13) {
            return false;
        }
        f12 = f * f5 - f4 * f2;
        return !(Math.abs(f12) > f3 * f10 + f6 * f13);
    }

    public final Vec3f getRayIntersection(Vec3f vec3f, Ray ray, float f, boolean bl) {
        block36: {
            int n;
            Vec3f vec3f2;
            Vec3f vec3f3;
            float[] fArray;
            block35: {
                fArray = new float[]{-1.0f, -1.0f, -1.0f};
                vec3f3 = ray.orig;
                vec3f2 = ray.dir;
                boolean bl2 = true;
                if (vec3f3.x() < this.lo.x()) {
                    vec3f.setX(this.lo.x());
                    bl2 = false;
                    if (0 != Float.floatToIntBits(vec3f2.x())) {
                        fArray[0] = (this.lo.x() - vec3f3.x()) / vec3f2.x();
                    }
                } else if (vec3f3.x() > this.hi.x()) {
                    vec3f.setX(this.hi.x());
                    bl2 = false;
                    if (0 != Float.floatToIntBits(vec3f2.x())) {
                        fArray[0] = (this.hi.x() - vec3f3.x()) / vec3f2.x();
                    }
                }
                if (vec3f3.y() < this.lo.y()) {
                    vec3f.setY(this.lo.y());
                    bl2 = false;
                    if (0 != Float.floatToIntBits(vec3f2.y())) {
                        fArray[1] = (this.lo.y() - vec3f3.y()) / vec3f2.y();
                    }
                } else if (vec3f3.y() > this.hi.y()) {
                    vec3f.setY(this.hi.y());
                    bl2 = false;
                    if (0 != Float.floatToIntBits(vec3f2.y())) {
                        fArray[1] = (this.hi.y() - vec3f3.y()) / vec3f2.y();
                    }
                }
                if (vec3f3.z() < this.lo.z()) {
                    vec3f.setZ(this.lo.z());
                    bl2 = false;
                    if (0 != Float.floatToIntBits(vec3f2.z())) {
                        fArray[2] = (this.lo.z() - vec3f3.z()) / vec3f2.z();
                    }
                } else if (vec3f3.z() > this.hi.z()) {
                    vec3f.setZ(this.hi.z());
                    bl2 = false;
                    if (0 != Float.floatToIntBits(vec3f2.z())) {
                        fArray[2] = (this.hi.z() - vec3f3.z()) / vec3f2.z();
                    }
                }
                if (bl2) {
                    vec3f.set(vec3f3);
                    return vec3f;
                }
                n = 0;
                if (fArray[1] > fArray[n]) {
                    n = 1;
                }
                if (fArray[2] > fArray[n]) {
                    n = 2;
                }
                if (bl) break block35;
                if (0 != (Float.floatToIntBits(fArray[n]) & Integer.MIN_VALUE)) {
                    return null;
                }
                switch (n) {
                    case 0: {
                        vec3f.setY(vec3f3.y() + fArray[n] * vec3f2.y());
                        if (vec3f.y() < this.lo.y() - f || vec3f.y() > this.hi.y() + f) {
                            return null;
                        }
                        vec3f.setZ(vec3f3.z() + fArray[n] * vec3f2.z());
                        if (vec3f.z() < this.lo.z() - f || vec3f.z() > this.hi.z() + f) {
                            return null;
                        }
                        break block36;
                    }
                    case 1: {
                        vec3f.setX(vec3f3.x() + fArray[n] * vec3f2.x());
                        if (vec3f.x() < this.lo.x() - f || vec3f.x() > this.hi.x() + f) {
                            return null;
                        }
                        vec3f.setZ(vec3f3.z() + fArray[n] * vec3f2.z());
                        if (vec3f.z() < this.lo.z() - f || vec3f.z() > this.hi.z() + f) {
                            return null;
                        }
                        break block36;
                    }
                    case 2: {
                        vec3f.setX(vec3f3.x() + fArray[n] * vec3f2.x());
                        if (vec3f.x() < this.lo.x() - f || vec3f.x() > this.hi.x() + f) {
                            return null;
                        }
                        vec3f.setY(vec3f3.y() + fArray[n] * vec3f2.y());
                        if (vec3f.y() < this.lo.y() - f || vec3f.y() > this.hi.y() + f) {
                            return null;
                        }
                        break block36;
                    }
                    default: {
                        throw new InternalError("XXX");
                    }
                }
            }
            switch (n) {
                case 0: {
                    vec3f.setY(vec3f3.y() + fArray[n] * vec3f2.y());
                    vec3f.setZ(vec3f3.z() + fArray[n] * vec3f2.z());
                    break;
                }
                case 1: {
                    vec3f.setX(vec3f3.x() + fArray[n] * vec3f2.x());
                    vec3f.setZ(vec3f3.z() + fArray[n] * vec3f2.z());
                    break;
                }
                case 2: {
                    vec3f.setX(vec3f3.x() + fArray[n] * vec3f2.x());
                    vec3f.setY(vec3f3.y() + fArray[n] * vec3f2.y());
                    break;
                }
                default: {
                    throw new InternalError("XXX");
                }
            }
        }
        return vec3f;
    }

    public final float getSize() {
        return this.lo.dist(this.hi);
    }

    public final Vec3f getCenter() {
        return this.center;
    }

    public final AABBox scale(float f) {
        Vec3f vec3f = new Vec3f();
        vec3f.set(this.hi).sub(this.center).scale(f);
        this.hi.set(this.center).add(vec3f);
        vec3f.set(this.lo).sub(this.center).scale(f);
        this.lo.set(this.center).add(vec3f);
        return this;
    }

    public final AABBox scale(float f, float f2, float f3) {
        Vec3f vec3f = new Vec3f();
        vec3f.set(this.hi).sub(this.center).mul(f, f2, f3);
        this.hi.set(this.center).add(vec3f);
        vec3f.set(this.lo).sub(this.center).mul(f, f2, f3);
        this.lo.set(this.center).add(vec3f);
        return this;
    }

    public final AABBox scale2(float f) {
        this.hi.scale(f);
        this.lo.scale(f);
        this.computeCenter();
        return this;
    }

    public final AABBox scale2(float f, float f2, float f3) {
        this.hi.mul(f, f2, f3);
        this.lo.mul(f, f2, f3);
        this.computeCenter();
        return this;
    }

    public final AABBox translate(float f, float f2, float f3) {
        this.lo.add(f, f2, f3);
        this.hi.add(f, f2, f3);
        this.computeCenter();
        return this;
    }

    public final AABBox translate(Vec3f vec3f) {
        this.lo.add(vec3f);
        this.hi.add(vec3f);
        this.computeCenter();
        return this;
    }

    public final AABBox rotate(Quaternion quaternion) {
        quaternion.rotateVector(this.lo, this.lo);
        quaternion.rotateVector(this.hi, this.hi);
        this.computeCenter();
        return this;
    }

    public final float getMinX() {
        return this.lo.x();
    }

    public final float getMinY() {
        return this.lo.y();
    }

    public final float getMinZ() {
        return this.lo.z();
    }

    public final float getMaxX() {
        return this.hi.x();
    }

    public final float getMaxY() {
        return this.hi.y();
    }

    public final float getMaxZ() {
        return this.hi.z();
    }

    public final float getWidth() {
        return this.hi.x() - this.lo.x();
    }

    public final float getHeight() {
        return this.hi.y() - this.lo.y();
    }

    public final float getDepth() {
        return this.hi.z() - this.lo.z();
    }

    public final float getVolume() {
        return this.getWidth() * this.getHeight() * this.getDepth();
    }

    public final boolean hasZeroVolume() {
        return FloatUtil.isZero(this.getVolume());
    }

    public final float get2DArea() {
        return this.getWidth() * this.getHeight();
    }

    public final boolean hasZero2DArea() {
        return FloatUtil.isZero(this.get2DArea());
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (null == object || !(object instanceof AABBox)) {
            return false;
        }
        AABBox aABBox = (AABBox)object;
        return this.lo.isEqual(aABBox.lo) && this.hi.isEqual(aABBox.hi);
    }

    public final int hashCode() {
        throw new InternalError("hashCode not designed");
    }

    public AABBox transform(Matrix4f matrix4f, AABBox aABBox) {
        Vec3f vec3f = new Vec3f();
        aABBox.reset();
        aABBox.resize(matrix4f.mulVec3f(this.lo, vec3f));
        aABBox.resize(matrix4f.mulVec3f(this.hi, vec3f));
        aABBox.computeCenter();
        return aABBox;
    }

    public AABBox mapToWindow(AABBox aABBox, Matrix4f matrix4f, Recti recti, boolean bl) {
        Vec3f vec3f = new Vec3f();
        Vec3f vec3f2 = new Vec3f();
        float f = bl ? this.center.z() : this.getMinZ();
        aABBox.reset();
        Matrix4f.mapObjToWin(vec3f.set(this.getMinX(), this.getMinY(), f), matrix4f, recti, vec3f2);
        aABBox.resize(vec3f2);
        Matrix4f.mapObjToWin(vec3f.set(this.getMinX(), this.getMaxY(), f), matrix4f, recti, vec3f2);
        aABBox.resize(vec3f2);
        Matrix4f.mapObjToWin(vec3f.set(this.getMaxX(), this.getMaxY(), f), matrix4f, recti, vec3f2);
        aABBox.resize(vec3f2);
        Matrix4f.mapObjToWin(vec3f.set(this.getMaxX(), this.getMinY(), f), matrix4f, recti, vec3f2);
        aABBox.resize(vec3f2);
        if (!bl) {
            f = this.getMaxZ();
            Matrix4f.mapObjToWin(vec3f.set(this.getMinX(), this.getMinY(), f), matrix4f, recti, vec3f2);
            aABBox.resize(vec3f2);
            Matrix4f.mapObjToWin(vec3f.set(this.getMinX(), this.getMaxY(), f), matrix4f, recti, vec3f2);
            aABBox.resize(vec3f2);
            Matrix4f.mapObjToWin(vec3f.set(this.getMaxX(), this.getMaxY(), f), matrix4f, recti, vec3f2);
            aABBox.resize(vec3f2);
            Matrix4f.mapObjToWin(vec3f.set(this.getMaxX(), this.getMinY(), f), matrix4f, recti, vec3f2);
            aABBox.resize(vec3f2);
        }
        if (DEBUG) {
            System.err.printf("AABBox.mapToWindow: view[%s], this %s -> %s%n", recti, this.toString(), aABBox.toString());
        }
        return aABBox;
    }

    public final String toString() {
        return "[dim " + this.getWidth() + " x " + this.getHeight() + " x " + this.getDepth() + ", box " + this.lo + " .. " + this.hi + ", ctr " + this.center + "]";
    }
}

