/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.Stamps;
import org.netbeans.Util;
import org.netbeans.core.startup.preferences.RelPaths;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;

public final class InstalledFileLocatorImpl
extends InstalledFileLocator {
    private static final Logger LOG = Logger.getLogger(InstalledFileLocatorImpl.class.getName());
    private final File[] dirs;
    private static Map<String, Map<File, Set<String>>> fileCache = null;
    private static Map<String, List<File>> clusterCache = null;
    private static boolean cacheMiss;
    private static final Pattern FILE_PATTERN;
    private static final Map<File, Map<String, Set<String>>> ownershipByModuleByCluster;

    public InstalledFileLocatorImpl() {
        List<File> _dirs = InstalledFileLocatorImpl.computeDirs();
        this.dirs = _dirs.toArray(new File[_dirs.size()]);
    }

    private static void addDir(List<File> _dirs, String d) {
        File f;
        if (d != null && (f = new File(d).getAbsoluteFile()).isDirectory()) {
            _dirs.add(FileUtil.normalizeFile((File)f));
        }
    }

    public static synchronized void prepareCache() {
        assert (fileCache == null);
        fileCache = new HashMap<String, Map<File, Set<String>>>();
        clusterCache = new HashMap<String, List<File>>();
        try {
            InputStream is = Stamps.getModulesJARs().asStream("all-files.dat");
            if (is == null) {
                return;
            }
            DataInputStream dis = new DataInputStream(is);
            int filesSize = dis.readInt();
            for (int i = 0; i < filesSize; ++i) {
                String key = dis.readUTF();
                HashMap fileToKids = new HashMap();
                int filesToKids = dis.readInt();
                for (int j = 0; j < filesToKids; ++j) {
                    String read = RelPaths.readRelativePath(dis);
                    File f = new File(read);
                    int kidsSize = dis.readInt();
                    ArrayList<String> kids = new ArrayList<String>(kidsSize);
                    for (int k = 0; k < kidsSize; ++k) {
                        kids.add(dis.readUTF());
                    }
                    fileToKids.put(f, new HashSet(kids));
                }
                fileCache.put(key, fileToKids);
            }
            int clusterSize = dis.readInt();
            for (int i = 0; i < clusterSize; ++i) {
                String key = dis.readUTF();
                int valueSize = dis.readInt();
                ArrayList<File> values = new ArrayList<File>(valueSize);
                for (int j = 0; j < valueSize; ++j) {
                    values.add(new File(RelPaths.readRelativePath(dis)));
                }
                clusterCache.put(key, values);
            }
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, null, ex);
            fileCache.clear();
            clusterCache.clear();
        }
    }

    private static synchronized void persistCache(DataOutputStream os, Map<String, Map<File, Set<String>>> fc, Map<String, List<File>> cc) throws IOException {
        os.writeInt(fc.size());
        for (Map.Entry<String, Map<File, Set<String>>> entry : fc.entrySet()) {
            os.writeUTF(entry.getKey());
            Map<File, Set<String>> map = entry.getValue();
            os.writeInt(map.size());
            for (Map.Entry<File, Set<String>> children : map.entrySet()) {
                String[] parts = RelPaths.findRelativePath(children.getKey().getPath());
                assert (parts != null) : "No relative for " + children.getKey();
                os.writeUTF(parts[0]);
                os.writeUTF(parts[1]);
                os.writeInt(children.getValue().size());
                for (String v : children.getValue()) {
                    os.writeUTF(v);
                }
            }
        }
        os.writeInt(cc.size());
        for (Map.Entry<String, Object> entry : cc.entrySet()) {
            os.writeUTF(entry.getKey());
            os.writeInt(((List)entry.getValue()).size());
            for (File file : (List)entry.getValue()) {
                String[] parts = RelPaths.findRelativePath(file.getPath());
                os.writeUTF(parts[0]);
                os.writeUTF(parts[1]);
            }
        }
    }

    public static synchronized void discardCache() {
        assert (fileCache != null);
        if (cacheMiss) {
            final Map<String, Map<File, Set<String>>> fc = fileCache;
            final Map<String, List<File>> cc = clusterCache;
            Stamps.getModulesJARs().scheduleSave(new Stamps.Updater(){

                public void flushCaches(DataOutputStream os) throws IOException {
                    InstalledFileLocatorImpl.persistCache(os, fc, cc);
                }

                public void cacheReady() {
                }
            }, "all-files.dat", false);
        }
        fileCache = null;
        clusterCache = null;
    }

    public File locate(String relativePath, String codeNameBase, boolean localized) {
        Set<File> files = this.doLocate(relativePath, localized, true, codeNameBase);
        return files.isEmpty() ? null : files.iterator().next();
    }

    public Set<File> locateAll(String relativePath, String codeNameBase, boolean localized) {
        return this.doLocate(relativePath, localized, false, codeNameBase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<File> doLocate(String relativePath, boolean localized, boolean single, String codeNameBase) {
        String[] prefixAndName = InstalledFileLocatorImpl.prefixAndName(relativePath);
        String prefix = prefixAndName[0];
        String name = prefixAndName[1];
        Class<InstalledFileLocatorImpl> clazz = InstalledFileLocatorImpl.class;
        synchronized (InstalledFileLocatorImpl.class) {
            if (localized) {
                String ext;
                String baseName;
                int i = name.lastIndexOf(46);
                if (i == -1) {
                    baseName = name;
                    ext = "";
                } else {
                    baseName = name.substring(0, i);
                    ext = name.substring(i);
                }
                Set<File> files = null;
                for (String suffix : Util.getLocalizingSuffixesFast()) {
                    String locName = baseName + suffix + ext;
                    Set<File> f = this.locateExactPath(prefix, locName, single, codeNameBase);
                    if (f.isEmpty()) continue;
                    if (single) {
                        // ** MonitorExit[var8_8] (shouldn't be in output)
                        return f;
                    }
                    if (files == null) {
                        files = f;
                        continue;
                    }
                    files = new LinkedHashSet<File>(files);
                    files.addAll(f);
                }
                // ** MonitorExit[var8_8] (shouldn't be in output)
                return files != null ? files : Collections.emptySet();
            }
            // ** MonitorExit[var8_8] (shouldn't be in output)
            return this.locateExactPath(prefix, name, single, codeNameBase);
        }
    }

    private Set<File> locateExactPath(String prefix, String name, boolean single, String codeNameBase) {
        assert (Thread.holdsLock(InstalledFileLocatorImpl.class));
        Set<File> files = null;
        String path = prefix + name;
        if (fileCache != null) {
            Map<File, Set<String>> fileCachePerPrefix = this.fileCachePerPrefix(prefix);
            for (File dir : this.clustersFor(codeNameBase, path)) {
                Set<String> names = fileCachePerPrefix.get(dir);
                if (names == null || !names.contains(name)) continue;
                assert (InstalledFileLocatorImpl.owned(codeNameBase, dir, path));
                File f = InstalledFileLocatorImpl.makeFile(dir, path);
                if (single) {
                    return Collections.singleton(f);
                }
                if (files == null) {
                    files = Collections.singleton(f);
                    continue;
                }
                files = new LinkedHashSet<File>(files);
                files.add(f);
            }
        } else {
            for (File dir : this.clustersFor(codeNameBase, path)) {
                File f = InstalledFileLocatorImpl.makeFile(dir, path);
                if (!f.exists()) continue;
                assert (InstalledFileLocatorImpl.owned(codeNameBase, dir, path));
                if (single) {
                    return Collections.singleton(f);
                }
                if (files == null) {
                    files = Collections.singleton(f);
                    continue;
                }
                files = new LinkedHashSet<File>(files);
                files.add(f);
            }
        }
        return files != null ? files : Collections.emptySet();
    }

    private List<File> clustersFor(String codeNameBase, String path) {
        List<File> clusters;
        assert (Thread.holdsLock(InstalledFileLocatorImpl.class));
        if (codeNameBase == null) {
            return Arrays.asList(this.dirs);
        }
        String codeNameBaseDashes = codeNameBase.replace('.', '-');
        if (path.matches("(modules/(locale/)?)?" + codeNameBaseDashes + "(_[^/]+)?[.]jar")) {
            return Arrays.asList(this.dirs);
        }
        List<File> list = clusters = clusterCache != null ? clusterCache.get(codeNameBase) : null;
        if (clusters == null) {
            clusters = new ArrayList<File>(1);
            String rel = "update_tracking/" + codeNameBaseDashes + ".xml";
            for (File dir : this.dirs) {
                File tracking = new File(dir, rel);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "checking {0} due to {1} cache={2}", new Object[]{tracking, path, clusterCache != null});
                }
                if (!tracking.isFile()) continue;
                clusters.add(dir);
            }
            if (clusterCache != null) {
                clusterCache.put(codeNameBase, clusters);
                InstalledFileLocatorImpl.scheduleSave();
            }
        }
        if (clusters.isEmpty()) {
            return Arrays.asList(this.dirs);
        }
        return clusters;
    }

    private static String[] prefixAndName(String relativePath) {
        String name;
        String prefix;
        if (relativePath.length() == 0) {
            throw new IllegalArgumentException("Cannot look up \"\" in InstalledFileLocator.locate");
        }
        if (relativePath.charAt(0) == '/') {
            throw new IllegalArgumentException("Paths passed to InstalledFileLocator.locate should not start with '/': " + relativePath);
        }
        int slashIdx = relativePath.lastIndexOf(47);
        if (slashIdx == relativePath.length() - 1) {
            throw new IllegalArgumentException("Paths passed to InstalledFileLocator.locate should not end in '/': " + relativePath);
        }
        if (slashIdx != -1) {
            prefix = relativePath.substring(0, slashIdx + 1);
            name = relativePath.substring(slashIdx + 1);
            assert (name.length() > 0);
        } else {
            prefix = "";
            name = relativePath;
        }
        return new String[]{prefix, name};
    }

    private Map<File, Set<String>> fileCachePerPrefix(String prefix) {
        assert (Thread.holdsLock(InstalledFileLocatorImpl.class));
        Map<File, Set<String>> fileCachePerPrefix = fileCache.get(prefix);
        if (fileCachePerPrefix == null) {
            fileCachePerPrefix = new HashMap<File, Set<String>>(this.dirs.length * 2);
            for (int i = 0; i < this.dirs.length; ++i) {
                boolean isDir;
                File d;
                File root = this.dirs[i];
                if (prefix.length() > 0) {
                    assert (prefix.charAt(prefix.length() - 1) == '/');
                    d = new File(root, prefix.substring(0, prefix.length() - 1).replace('/', File.separatorChar));
                    isDir = d.isDirectory();
                } else {
                    d = root;
                    isDir = true;
                }
                if (!isDir) continue;
                String[] kids = d.list();
                if (kids != null) {
                    fileCachePerPrefix.put(root, new HashSet<String>(Arrays.asList(kids)));
                    continue;
                }
                Util.err.log(Level.WARNING, "could not read files in {0} at {1}", new Object[]{d, InstalledFileLocatorImpl.findCaller()});
            }
            fileCache.put(prefix, fileCachePerPrefix);
            InstalledFileLocatorImpl.scheduleSave();
        }
        return fileCachePerPrefix;
    }

    private static File makeFile(File dir, String path) {
        return new File(dir, path.replace('/', File.separatorChar));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized boolean owned(String codeNameBase, File dir, String path) {
        Set<String> ownership;
        if (codeNameBase == null) {
            LOG.log(Level.WARNING, "no code name base passed when looking up {0} at {1}", new Object[]{path, InstalledFileLocatorImpl.findCaller()});
            return true;
        }
        if (path.lastIndexOf(95) > path.lastIndexOf(47)) {
            return true;
        }
        String codeNameBaseDashes = codeNameBase.replace('.', '-');
        if (path.equals("modules/" + codeNameBaseDashes + ".jar")) {
            return true;
        }
        if (path.equals("update_tracking/" + codeNameBaseDashes + ".xml")) {
            return true;
        }
        Map<String, Set<String>> ownershipByModule = ownershipByModuleByCluster.get(dir);
        File updateDir = new File(dir, "update_tracking");
        if (ownershipByModule == null) {
            if (!updateDir.isDirectory()) {
                LOG.log(Level.FINE, "No update tracking found in {0}", dir);
                return true;
            }
            ownershipByModule = new HashMap<String, Set<String>>();
            ownershipByModuleByCluster.put(dir, ownershipByModule);
        }
        if ((ownership = ownershipByModule.get(codeNameBase)) == null) {
            File list = new File(updateDir, codeNameBaseDashes + ".xml");
            if (!list.isFile()) {
                LOG.log(Level.WARNING, "no such module {0} at {1}", new Object[]{list, InstalledFileLocatorImpl.findCaller()});
                return true;
            }
            ownership = new HashSet<String>();
            try {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "Parsing {0} due to {1}", new Object[]{list, path});
                }
                try (FileReader r = new FileReader(list);){
                    String line;
                    BufferedReader br = new BufferedReader(r);
                    while ((line = br.readLine()) != null) {
                        Matcher m = FILE_PATTERN.matcher(line);
                        if (!m.matches()) continue;
                        ownership.add(m.group(1));
                    }
                    br.close();
                }
            }
            catch (IOException x) {
                LOG.log(Level.INFO, "could not parse " + list, x);
                return true;
            }
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "parsed {0} -> {1}", new Object[]{list, ownership});
            }
            ownershipByModule.put(codeNameBase, ownership);
        }
        if (!ownership.contains(path)) {
            boolean found = false;
            if (InstalledFileLocatorImpl.makeFile(dir, path).isDirectory()) {
                String pathSlash = path + "/";
                for (String owned : ownership) {
                    if (!owned.startsWith(pathSlash)) continue;
                    found = true;
                    break;
                }
            }
            if (!found) {
                LOG.log(Level.WARNING, "module {0} in {1} does not own {2} at {3}", new Object[]{codeNameBase, dir, path, InstalledFileLocatorImpl.findCaller()});
            }
        }
        return true;
    }

    private static String findCaller() {
        for (StackTraceElement line : Thread.currentThread().getStackTrace()) {
            if (line.getClassName().matches(".*InstalledFileLocator.*|java[.].+")) continue;
            return line.toString();
        }
        return "???";
    }

    private static synchronized void scheduleSave() {
        cacheMiss = true;
    }

    static List<File> computeDirs() {
        ArrayList<File> _dirs = new ArrayList<File>();
        InstalledFileLocatorImpl.addDir(_dirs, System.getProperty("netbeans.user"));
        String nbdirs = System.getProperty("netbeans.dirs");
        if (nbdirs != null) {
            StringTokenizer tok = new StringTokenizer(nbdirs, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                InstalledFileLocatorImpl.addDir(_dirs, tok.nextToken());
            }
        }
        InstalledFileLocatorImpl.addDir(_dirs, System.getProperty("netbeans.home"));
        return _dirs;
    }

    static {
        FILE_PATTERN = Pattern.compile("\\s*<file.+name=[\"']([^\"']+)[\"'].*/>");
        ownershipByModuleByCluster = new HashMap<File, Map<String, Set<String>>>();
    }
}

