/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.banner;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import org.gephi.desktop.banner.workspace.WorkspacePanel;
import org.gephi.perspective.api.PerspectiveController;
import org.gephi.perspective.spi.Perspective;
import org.gephi.ui.utils.UIUtils;
import org.openide.util.Lookup;

public class BannerComponent
extends JPanel {
    private final transient PerspectiveController perspectiveController;
    private JPanel buttonsPanel;
    private JPanel mainPanel;
    private ButtonGroup perspectivesButtonGroup;
    private JPanel workspacePanel;

    public BannerComponent() {
        this.initComponents();
        if (UIUtils.isFlatLafLightLookAndFeel()) {
            this.mainPanel.setBackground(Color.WHITE);
            this.workspacePanel.setBackground(Color.WHITE);
        } else if (UIUtils.isFlatLafDarkLookAndFeel()) {
            Color cl = UIManager.getColor("EditorTab.background");
            this.mainPanel.setBackground(cl);
            this.workspacePanel.setBackground(cl);
        }
        this.buttonsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getColor("Component.borderColor")), BorderFactory.createEmptyBorder(6, 0, 6, 5)));
        this.workspacePanel.setBorder(BorderFactory.createEmptyBorder(12, 0, 0, 0));
        this.perspectiveController = (PerspectiveController)Lookup.getDefault().lookup(PerspectiveController.class);
        this.addGroupTabs();
    }

    private void addGroupTabs() {
        JToggleButton[] buttons = new JToggleButton[this.perspectiveController.getPerspectives().length];
        int i = 0;
        for (Perspective perspective : this.perspectiveController.getPerspectives()) {
            JToggleButton toggleButton = new JToggleButton(perspective.getDisplayName(), perspective.getIcon());
            toggleButton.setFocusPainted(false);
            toggleButton.setCursor(Cursor.getPredefinedCursor(12));
            toggleButton.addActionListener(e -> this.perspectiveController.selectPerspective(perspective));
            this.perspectivesButtonGroup.add(toggleButton);
            this.buttonsPanel.add(toggleButton);
            buttons[i++] = toggleButton;
        }
        this.perspectivesButtonGroup.setSelected(buttons[this.getSelectedPerspectiveIndex()].getModel(), true);
    }

    public int getSelectedPerspectiveIndex() {
        int i = 0;
        for (Perspective p : this.perspectiveController.getPerspectives()) {
            if (p.equals(this.perspectiveController.getSelectedPerspective())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void initComponents() {
        this.perspectivesButtonGroup = new ButtonGroup();
        this.mainPanel = new JPanel();
        this.workspacePanel = new WorkspacePanel();
        this.buttonsPanel = new JPanel();
        this.setBackground(new Color(255, 255, 255));
        this.setLayout(new BorderLayout());
        this.mainPanel.setLayout(new BorderLayout());
        this.workspacePanel.setBorder(BorderFactory.createEmptyBorder(6, 0, 0, 0));
        this.mainPanel.add((Component)this.workspacePanel, "Center");
        this.buttonsPanel.setOpaque(false);
        this.buttonsPanel.setLayout(new FlowLayout(1, 6, 0));
        this.mainPanel.add((Component)this.buttonsPanel, "West");
        this.add((Component)this.mainPanel, "Center");
    }
}

