/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.exceptionhandlers.gcc.structures.ehFrame;

import ghidra.app.cmd.data.CreateStructureCmd;
import ghidra.app.plugin.exceptionhandlers.gcc.DwarfDecodeContext;
import ghidra.app.plugin.exceptionhandlers.gcc.DwarfEHDecoder;
import ghidra.app.plugin.exceptionhandlers.gcc.structures.ehFrame.ExceptionHandlerFrameException;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.task.TaskMonitor;

public class FdeTable {
    TaskMonitor monitor;
    Program prog;
    StructureDataType fdeTableEntry;

    public FdeTable(TaskMonitor monitor, Program curProg) {
        this.monitor = monitor;
        this.prog = curProg;
        this.fdeTableEntry = new StructureDataType("fde_table_entry", 0);
    }

    private void initFdeTableDataType(DwarfEHDecoder decoder) throws ExceptionHandlerFrameException {
        DataType encodedDt = decoder.getDataType(this.prog);
        if (encodedDt.getLength() <= 0) {
            throw new ExceptionHandlerFrameException("Cannot build FDE structure with Dynamic or Void value type: " + encodedDt.getClass().getName());
        }
        if (encodedDt.hasLanguageDependantLength()) {
            throw new ExceptionHandlerFrameException("Cannot build FDE structure with dynamically-sized value type: " + encodedDt.getClass().getName());
        }
        this.fdeTableEntry.deleteAll();
        this.fdeTableEntry.add(encodedDt, "initial_loc", "Initial Location");
        this.fdeTableEntry.add(encodedDt, "data_loc", "Data location");
        ProgramBasedDataTypeManager dtManager = this.prog.getDataTypeManager();
        dtManager.addDataType((DataType)this.fdeTableEntry, DataTypeConflictHandler.REPLACE_HANDLER);
    }

    public void create(Address addr, DwarfEHDecoder decoder, long fdeTableCnt) throws MemoryAccessException, ExceptionHandlerFrameException {
        CreateStructureCmd dataCmd = null;
        long curFdeTableCnt = 0L;
        if (addr == null || decoder == null) {
            return;
        }
        this.initFdeTableDataType(decoder);
        this.monitor.setMessage("Creating Frame Description Table Entries");
        this.monitor.setShowProgressValue(true);
        this.monitor.setIndeterminate(false);
        this.monitor.initialize(fdeTableCnt);
        MemoryBlock curMemBlock = this.prog.getMemory().getBlock(".eh_frame_hdr");
        while (curMemBlock != null && addr.compareTo((Object)curMemBlock.getEnd()) < 0 && curFdeTableCnt < fdeTableCnt) {
            if (this.monitor.isCancelled()) {
                return;
            }
            dataCmd = new CreateStructureCmd((Structure)this.fdeTableEntry, addr);
            dataCmd.applyTo(this.prog);
            Data fdeTableData = this.prog.getListing().getDataAt(addr);
            Structure fdeStruct = (Structure)fdeTableData.getDataType();
            DataTypeComponent locComponent = fdeStruct.getComponent(0);
            Address locComponentAddr = addr.add((long)locComponent.getOffset());
            DwarfDecodeContext locDecodeContext = new DwarfDecodeContext(this.prog, locComponentAddr, curMemBlock);
            Address locAddr = decoder.decodeAddress(locDecodeContext);
            this.prog.getReferenceManager().addMemoryReference(locComponentAddr, locAddr, (RefType)RefType.INDIRECTION, SourceType.ANALYSIS, 0);
            DataTypeComponent dataComponent = fdeStruct.getComponent(1);
            Address dataComponentAddr = addr.add((long)dataComponent.getOffset());
            DwarfDecodeContext dataDecodeContext = new DwarfDecodeContext(this.prog, dataComponentAddr, curMemBlock);
            Address dataAddr = decoder.decodeAddress(dataDecodeContext);
            this.prog.getReferenceManager().addMemoryReference(dataComponentAddr, dataAddr, RefType.DATA, SourceType.ANALYSIS, 0);
            ++curFdeTableCnt;
            addr = addr.add((long)this.fdeTableEntry.getLength());
            this.monitor.incrementProgress(1L);
        }
    }
}

