/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import java.util.ArrayList;
import org.hibernate.cache.MutableCacheKeyBuilder;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.IndexedConsumer;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingModelExpressible;

public class TupleMappingModelExpressible
implements MappingModelExpressible {
    private final MappingModelExpressible<Object>[] components;
    private final JdbcMapping[] mappings;

    public TupleMappingModelExpressible(MappingModelExpressible<?>[] components) {
        this.components = components;
        ArrayList results = new ArrayList();
        this.forEachJdbcType(0, (index, jdbcMapping) -> results.add(jdbcMapping));
        this.mappings = results.toArray(new JdbcMapping[0]);
    }

    @Override
    public JdbcMapping getJdbcMapping(int index) {
        return this.mappings[index];
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        int span = 0;
        for (int i = 0; i < this.components.length; ++i) {
            span += this.components[i].forEachJdbcType(offset + span, action);
        }
        return span;
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        Object[] disassembled = new Object[this.components.length];
        Object[] array = (Object[])value;
        for (int i = 0; i < this.components.length; ++i) {
            disassembled[i] = this.components[i].disassemble(array[i], session);
        }
        return disassembled;
    }

    @Override
    public void addToCacheKey(MutableCacheKeyBuilder cacheKey, Object value, SharedSessionContractImplementor session) {
        if (value == null) {
            for (int i = 0; i < this.components.length; ++i) {
                this.components[i].addToCacheKey(cacheKey, null, session);
            }
        } else {
            Object[] array = (Object[])value;
            for (int i = 0; i < this.components.length; ++i) {
                this.components[i].addToCacheKey(cacheKey, array[i], session);
            }
        }
    }

    @Override
    public <X, Y> int forEachDisassembledJdbcValue(Object value, int offset, X x, Y y, Bindable.JdbcValuesBiConsumer<X, Y> valuesConsumer, SharedSessionContractImplementor session) {
        int span = 0;
        if (value == null) {
            for (int i = 0; i < this.components.length; ++i) {
                span += this.components[i].forEachDisassembledJdbcValue(null, span + offset, x, y, valuesConsumer, session);
            }
        } else {
            Object[] values = (Object[])value;
            for (int i = 0; i < this.components.length; ++i) {
                span += this.components[i].forEachDisassembledJdbcValue(values[i], span + offset, x, y, valuesConsumer, session);
            }
        }
        return span;
    }

    @Override
    public <X, Y> int forEachJdbcValue(Object value, int offset, X x, Y y, Bindable.JdbcValuesBiConsumer<X, Y> valuesConsumer, SharedSessionContractImplementor session) {
        int span = 0;
        if (value == null) {
            for (int i = 0; i < this.components.length; ++i) {
                span += this.components[i].forEachDisassembledJdbcValue(this.components[i].disassemble(null, session), span + offset, x, y, valuesConsumer, session);
            }
        } else {
            Object[] values = (Object[])value;
            for (int i = 0; i < this.components.length; ++i) {
                span += this.components[i].forEachDisassembledJdbcValue(this.components[i].disassemble(values[i], session), span + offset, x, y, valuesConsumer, session);
            }
        }
        return span;
    }
}

