/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.util.IntSet;

class ConcurrentSmallIntSet
implements IntSet {
    private final AtomicIntegerArray array;
    private static final int ADDRESS_BITS_PER_INT = 5;
    private static final int INT_MASK = -1;
    private final AtomicInteger currentSize = new AtomicInteger();

    public ConcurrentSmallIntSet(int maxCapacityExclusive) {
        if (maxCapacityExclusive < 1) {
            throw new IllegalArgumentException("maxCapacityExclusive (" + maxCapacityExclusive + ") < 1");
        }
        int intLength = this.intIndex(maxCapacityExclusive + 31);
        this.array = new AtomicIntegerArray(intLength);
    }

    private void valueNonZero(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("The provided value " + value + " must be 0 or greater");
        }
    }

    private void checkBounds(int index) {
        if (index >= this.array.length()) {
            throw new IllegalArgumentException("Provided integer " + index + " was larger than originally initialized size " + this.array.length());
        }
    }

    private int intIndex(int bitIndex) {
        return bitIndex >> 5;
    }

    @Override
    public int nextSetBit(int fromIndex) {
        int arrayLength;
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        int u = this.intIndex(fromIndex);
        if (u >= (arrayLength = this.array.length())) {
            return -1;
        }
        int possible = this.array.get(u) & -1 << fromIndex;
        while (possible == 0) {
            if (++u == arrayLength) {
                return -1;
            }
            possible = this.array.get(u);
        }
        return (u << 5) + Integer.numberOfTrailingZeros(possible);
    }

    @Override
    public boolean add(int i) {
        int num2;
        int num;
        this.valueNonZero(i);
        int bit = 1 << i;
        int idx = this.intIndex(i);
        this.checkBounds(idx);
        do {
            if ((num = this.array.get(idx)) != (num2 = num | bit)) continue;
            return false;
        } while (!this.array.compareAndSet(idx, num, num2));
        this.currentSize.incrementAndGet();
        return true;
    }

    @Override
    public void set(int i) {
        this.add(i);
    }

    @Override
    public boolean remove(int i) {
        int unsetNum;
        int num;
        this.valueNonZero(i);
        int idx = this.intIndex(i);
        this.checkBounds(idx);
        int bit = 1 << i;
        do {
            if ((num = this.array.get(idx)) != (unsetNum = num & ~bit)) continue;
            return false;
        } while (!this.array.compareAndSet(idx, num, unsetNum));
        this.currentSize.decrementAndGet();
        return true;
    }

    @Override
    public boolean contains(int i) {
        int bit;
        this.valueNonZero(i);
        int idx = this.intIndex(i);
        if (idx >= this.array.length()) {
            return false;
        }
        int num = this.array.get(idx);
        return (num & (bit = 1 << i)) != 0;
    }

    @Override
    public boolean addAll(IntSet set) {
        boolean changed = false;
        PrimitiveIterator.OfInt iter = set.iterator();
        while (iter.hasNext()) {
            changed |= this.add(iter.nextInt());
        }
        return changed;
    }

    @Override
    public boolean containsAll(IntSet set) {
        PrimitiveIterator.OfInt iter = set.iterator();
        while (iter.hasNext()) {
            if (this.contains(iter.nextInt())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(IntSet set) {
        boolean modified = false;
        PrimitiveIterator.OfInt iter = set.iterator();
        while (iter.hasNext()) {
            modified |= this.remove(iter.nextInt());
        }
        return modified;
    }

    @Override
    public boolean retainAll(IntSet set) {
        boolean modified = false;
        for (int i = 0; i < this.array.length(); ++i) {
            int posValue = this.array.get(i);
            int offset = 1;
            while (posValue > 0) {
                int ourValue;
                if ((posValue & 1) == 1 && !set.contains(ourValue = (i << 5) + offset - 1)) {
                    modified |= this.remove(ourValue);
                }
                posValue >>= 1;
                ++offset;
            }
        }
        return modified;
    }

    @Override
    public int size() {
        return this.currentSize.get();
    }

    @Override
    public boolean isEmpty() {
        return this.currentSize.get() == 0;
    }

    @Override
    public boolean contains(Object o) {
        return o instanceof Integer && this.contains((Integer)o);
    }

    @Override
    public PrimitiveIterator.OfInt iterator() {
        return new ConcurrentIntIterator();
    }

    @Override
    public final Object[] toArray() {
        int size = this.currentSize.get();
        Object[] r = new Object[size];
        int index = 0;
        for (int i = 0; i < this.array.length(); ++i) {
            int value = this.array.get(i);
            int offset = 1;
            while (value > 0) {
                if ((value & 1) == 1) {
                    if (index == size) {
                        size += (size >>> 1) + 1;
                        r = Arrays.copyOf(r, size);
                    }
                    r[index++] = (i << 5) + offset - 1;
                }
                value >>= 1;
                ++offset;
            }
        }
        return index == size ? r : Arrays.copyOf(r, size);
    }

    @Override
    public final <T> T[] toArray(T[] a) {
        int currentSize = this.currentSize.get();
        T[] r = a.length >= currentSize ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), currentSize);
        int n = r.length;
        int i = 0;
        for (Integer e : this) {
            if (i == n) {
                n += (n >>> 1) + 1;
                r = Arrays.copyOf(r, n);
            }
            r[i++] = e;
        }
        if (a == r && i < n) {
            r[i] = null;
            return r;
        }
        return i == n ? r : Arrays.copyOf(r, i);
    }

    @Override
    public boolean add(Integer integer) {
        return this.add((int)integer);
    }

    @Override
    public boolean remove(Object o) {
        return o instanceof Integer && this.remove((Integer)o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c instanceof IntSet) {
            return this.containsAll((IntSet)c);
        }
        for (Object obj : c) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Integer> c) {
        if (c instanceof IntSet) {
            return this.addAll((IntSet)c);
        }
        boolean changed = false;
        for (Integer n : c) {
            changed |= this.add(n);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean modified = false;
        PrimitiveIterator.OfInt iter = this.iterator();
        while (iter.hasNext()) {
            int value = iter.nextInt();
            if (c.contains(value)) continue;
            iter.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object value : c) {
            modified |= this.remove(value);
        }
        return modified;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.array.length(); ++i) {
            int oldValue = this.array.getAndSet(i, 0);
            int bitsSet = Integer.bitCount(oldValue);
            if (bitsSet == 0) continue;
            this.currentSize.addAndGet(-bitsSet);
        }
    }

    @Override
    public IntStream intStream() {
        return StreamSupport.intStream(this.intSpliterator(), false);
    }

    @Override
    public Spliterator.OfInt intSpliterator() {
        return IntSet.super.intSpliterator();
    }

    @Override
    public int[] toIntArray() {
        int size = this.currentSize.get();
        int[] r = new int[size];
        int index = 0;
        for (int i = 0; i < this.array.length(); ++i) {
            int value = this.array.get(i);
            int offset = 1;
            while (value != 0) {
                if ((value & 1) == 1) {
                    if (index == size) {
                        size += (size >>> 1) + 1;
                        r = Arrays.copyOf(r, size);
                    }
                    r[index++] = (i << 5) + offset - 1;
                }
                value >>>= 1;
                ++offset;
            }
        }
        return index == size ? r : Arrays.copyOf(r, size);
    }

    @Override
    public byte[] toBitSet() {
        byte[] bytes = new byte[this.array.length() * 8];
        ByteBuffer bb = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < this.array.length(); ++i) {
            int value = this.array.get(i);
            bb.putInt(value);
        }
        return bb.array();
    }

    @Override
    public void forEach(Consumer<? super Integer> action) {
        if (action instanceof IntConsumer) {
            this.forEach((IntConsumer)((Object)action));
        } else {
            this.forEach(action::accept);
        }
    }

    @Override
    public void forEach(IntConsumer action) {
        for (int i = 0; i < this.array.length(); ++i) {
            int value = this.array.get(i);
            int offset = 1;
            while (value != 0) {
                if ((value & 1) == 1) {
                    action.accept((i << 5) + offset - 1);
                }
                value >>>= 1;
                ++offset;
            }
        }
    }

    @Override
    public boolean removeIf(Predicate<? super Integer> filter) {
        if (filter instanceof IntPredicate) {
            return this.removeIf((IntPredicate)((Object)filter));
        }
        return this.removeIf(filter::test);
    }

    @Override
    public boolean removeIf(IntPredicate filter) {
        boolean modified = false;
        for (int i = 0; i < this.array.length(); ++i) {
            int value = this.array.get(i);
            int offset = 1;
            while (value != 0) {
                int ourValue;
                if ((value & 1) == 1 && filter.test(ourValue = (i << 5) + offset - 1)) {
                    modified |= this.remove(ourValue);
                }
                value >>>= 1;
                ++offset;
            }
        }
        return modified;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Set)) {
            return false;
        }
        Set set = (Set)o;
        return this.size() == set.size() && this.containsAll(set);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        for (int i = 0; i < this.array.length(); ++i) {
            int value = this.array.get(i);
            hashCode *= 37;
            hashCode += value;
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        int i = this.nextSetBit(0);
        while (i >= 0) {
            if (sb.length() > "{".length()) {
                sb.append(' ');
            }
            int runStart = i;
            while (this.contains(i + 1)) {
                ++i;
            }
            if (i == runStart) {
                sb.append(i);
            } else {
                sb.append(runStart).append('-').append(i);
            }
            i = this.nextSetBit(i + 1);
        }
        sb.append('}');
        return sb.toString();
    }

    static void writeTo(ObjectOutput output, ConcurrentSmallIntSet intSet) throws IOException {
        int arrayLength = intSet.array.length();
        UnsignedNumeric.writeUnsignedInt(output, arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            output.writeInt(intSet.array.get(i));
        }
    }

    static IntSet readFrom(ObjectInput input) throws IOException {
        int arrayLength = UnsignedNumeric.readUnsignedInt(input);
        ConcurrentSmallIntSet intSet = new ConcurrentSmallIntSet(arrayLength << 5);
        int size = 0;
        for (int i = 0; i < arrayLength - 1; ++i) {
            int value = input.readInt();
            intSet.array.lazySet(i, value);
            size += Integer.bitCount(value);
        }
        int lastValue = input.readInt();
        intSet.array.set(arrayLength - 1, lastValue);
        intSet.currentSize.addAndGet(size += Integer.bitCount(lastValue));
        return intSet;
    }

    private class ConcurrentIntIterator
    implements PrimitiveIterator.OfInt {
        private int currentValue;
        private int prevValue = -1;

        ConcurrentIntIterator() {
            this.currentValue = ConcurrentSmallIntSet.this.nextSetBit(0);
        }

        @Override
        public int nextInt() {
            if (this.currentValue < 0) {
                throw new NoSuchElementException();
            }
            this.prevValue = this.currentValue;
            this.currentValue = ConcurrentSmallIntSet.this.nextSetBit(this.currentValue + 1);
            return this.prevValue;
        }

        @Override
        public boolean hasNext() {
            return this.currentValue >= 0;
        }

        @Override
        public void remove() {
            if (this.prevValue < 0) {
                throw new IllegalStateException();
            }
            ConcurrentSmallIntSet.this.remove(this.prevValue);
            this.prevValue = -1;
        }
    }
}

