/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.keybinding;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.jose.jwk.JSONWebKeySet;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jwk.JWKBuilder;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oid4vc.issuance.keybinding.AttestationProofValidator;
import org.keycloak.protocol.oid4vc.issuance.keybinding.ProofValidator;
import org.keycloak.protocol.oid4vc.issuance.keybinding.ProofValidatorFactory;
import org.keycloak.protocol.oid4vc.issuance.keybinding.StaticAttestationKeyResolver;
import org.keycloak.protocol.oidc.utils.JWKSServerUtils;
import org.keycloak.util.JsonSerialization;

public class AttestationProofValidatorFactory
implements ProofValidatorFactory {
    private static final Logger logger = Logger.getLogger(AttestationProofValidatorFactory.class);

    public String getId() {
        return "attestation";
    }

    public ProofValidator create(KeycloakSession session) {
        Map<String, JWK> trustedKeys = this.loadTrustedKeysFromRealm(session);
        StaticAttestationKeyResolver resolver = new StaticAttestationKeyResolver(trustedKeys);
        return new AttestationProofValidator(session, resolver);
    }

    private Map<String, JWK> loadTrustedKeysFromRealm(KeycloakSession session) {
        RealmModel realm = session.getContext().getRealm();
        if (realm == null) {
            logger.debugf("No realm available, returning empty trusted keys map", new Object[0]);
            return Map.of();
        }
        Map<String, JWK> sessionKeys = this.loadKeysFromSession(session, realm);
        Map<String, JWK> attributeKeys = this.loadKeysFromRealmAttribute(realm);
        Map<String, JWK> keyIdsKeys = this.loadKeysByKeyIds(session, realm);
        HashMap<String, JWK> mergedKeys = new HashMap<String, JWK>(sessionKeys);
        mergedKeys.putAll(attributeKeys);
        mergedKeys.putAll(keyIdsKeys);
        if (mergedKeys.isEmpty()) {
            logger.debugf("No trusted keys found for attestation proof validation", new Object[0]);
        } else {
            logger.debugf("Loaded %d trusted keys for attestation proof validation (%d from session, %d from realm attribute JSON, %d from realm attribute key IDs)", new Object[]{mergedKeys.size(), sessionKeys.size(), attributeKeys.size(), keyIdsKeys.size()});
        }
        return Collections.unmodifiableMap(mergedKeys);
    }

    private Map<String, JWK> loadKeysFromSession(KeycloakSession session, RealmModel realm) {
        try {
            JSONWebKeySet keySet = JWKSServerUtils.getRealmJwks(session, realm);
            if (keySet == null || keySet.getKeys() == null) {
                return Map.of();
            }
            return Stream.of(keySet.getKeys()).filter(jwk -> jwk != null && jwk.getKeyId() != null).collect(Collectors.toMap(JWK::getKeyId, jwk -> jwk, (existing, replacement) -> existing));
        }
        catch (Exception e) {
            logger.warnf((Throwable)e, "Failed to load keys from session for realm '%s'", (Object)realm.getName());
            return Map.of();
        }
    }

    private Map<String, JWK> loadKeysFromRealmAttribute(RealmModel realm) {
        String trustedKeysJson = realm.getAttribute("oid4vc.attestation.trusted_keys");
        if (trustedKeysJson == null || trustedKeysJson.trim().isEmpty()) {
            return Map.of();
        }
        try {
            return this.parseTrustedKeys(trustedKeysJson);
        }
        catch (Exception e) {
            logger.warnf((Throwable)e, "Failed to parse trusted keys from realm attribute '%s'", (Object)"oid4vc.attestation.trusted_keys");
            return Map.of();
        }
    }

    private Map<String, JWK> loadKeysByKeyIds(KeycloakSession session, RealmModel realm) {
        String trustedKeyIds = realm.getAttribute("oid4vc.attestation.trusted_key_ids");
        if (trustedKeyIds == null || trustedKeyIds.trim().isEmpty()) {
            return Map.of();
        }
        Set keyIds = Arrays.stream(trustedKeyIds.split(",")).map(String::trim).filter(id -> !id.isEmpty()).collect(Collectors.toSet());
        if (keyIds.isEmpty()) {
            return Map.of();
        }
        HashMap keyMap = new HashMap();
        session.keys().getKeysStream(realm).filter(key -> keyIds.contains(key.getKid()) && key.getPublicKey() != null).forEach(key -> {
            try {
                JWKBuilder builder = JWKBuilder.create().kid(key.getKid()).algorithm(key.getAlgorithmOrDefault());
                List certificates = Optional.ofNullable(key.getCertificateChain()).filter(certs -> !certs.isEmpty()).orElseGet(() -> Optional.ofNullable(key.getCertificate()).map(Collections::singletonList).orElseGet(Collections::emptyList));
                JWK jwk = null;
                if (Objects.equals(key.getType(), "RSA")) {
                    jwk = builder.rsa(key.getPublicKey(), certificates, key.getUse());
                } else if (Objects.equals(key.getType(), "EC")) {
                    jwk = builder.ec(key.getPublicKey(), certificates, key.getUse());
                } else if (Objects.equals(key.getType(), "OKP")) {
                    jwk = builder.okp(key.getPublicKey(), key.getUse());
                }
                if (jwk != null) {
                    keyMap.put(key.getKid(), jwk);
                } else {
                    logger.debugf("Unsupported key type '%s' for key '%s'", (Object)key.getType(), (Object)key.getKid());
                }
            }
            catch (Exception e) {
                logger.warnf((Throwable)e, "Failed to convert key '%s' to JWK format", (Object)key.getKid());
            }
        });
        Set foundKeyIds = keyMap.keySet();
        Set missingKeyIds = keyIds.stream().filter(id -> !foundKeyIds.contains(id)).collect(Collectors.toSet());
        if (!missingKeyIds.isEmpty()) {
            logger.warnf("The following key IDs from realm attribute '%s' were not found in realm key providers: %s", (Object)"oid4vc.attestation.trusted_key_ids", missingKeyIds);
        }
        if (!keyMap.isEmpty()) {
            logger.debugf("Loaded %d trusted keys by key ID from realm attribute (including potentially disabled keys)", keyMap.size());
        }
        return Collections.unmodifiableMap(keyMap);
    }

    private Map<String, JWK> parseTrustedKeys(String json) {
        if (json == null || json.trim().isEmpty()) {
            return Map.of();
        }
        try {
            List keys = (List)JsonSerialization.mapper.readValue(json, (TypeReference)new TypeReference<List<JWK>>(){});
            if (keys == null || keys.isEmpty()) {
                return Map.of();
            }
            HashMap<String, JWK> keyMap = new HashMap<String, JWK>();
            for (JWK key : keys) {
                String kid = key.getKeyId();
                if (kid == null || kid.trim().isEmpty()) {
                    logger.warnf("Skipping JWK without 'kid' field in trusted keys configuration", new Object[0]);
                    continue;
                }
                keyMap.put(kid, key);
            }
            logger.debugf("Loaded %d trusted keys from realm attribute JSON", keyMap.size());
            return Collections.unmodifiableMap(keyMap);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid JSON format for trusted keys: " + e.getMessage(), e);
        }
    }
}

