/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.TimeUnit;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.keycloak.dom.saml.v2.metadata.EndpointType;
import org.keycloak.dom.saml.v2.metadata.EntityDescriptorType;
import org.keycloak.dom.saml.v2.metadata.IndexedEndpointType;
import org.keycloak.dom.saml.v2.metadata.KeyDescriptorType;
import org.keycloak.dom.saml.v2.metadata.KeyTypes;
import org.keycloak.dom.saml.v2.metadata.SPSSODescriptorType;
import org.keycloak.dom.saml.v2.metadata.SSODescriptorType;
import org.keycloak.dom.xmlsec.w3.xmlenc.EncryptionMethodType;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.util.DocumentUtil;
import org.keycloak.saml.processing.core.saml.v2.common.IDGenerator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SPMetadataDescriptor {
    public static EntityDescriptorType buildSPDescriptor(URI loginBinding, URI logoutBinding, URI assertionEndpoint, URI logoutEndpoint, boolean wantAuthnRequestsSigned, boolean wantAssertionsSigned, boolean wantAssertionsEncrypted, String entityId, String nameIDPolicyFormat, List<KeyDescriptorType> signingCerts, List<KeyDescriptorType> encryptionCerts) {
        return SPMetadataDescriptor.buildSPDescriptor(Collections.singletonList(new EndpointType(loginBinding, assertionEndpoint)), Collections.singletonList(new EndpointType(logoutBinding, logoutEndpoint)), wantAuthnRequestsSigned, wantAssertionsSigned, wantAssertionsEncrypted, entityId, nameIDPolicyFormat, signingCerts, encryptionCerts, null);
    }

    public static EntityDescriptorType buildSPDescriptor(List<EndpointType> assertionConsumerServices, List<EndpointType> singleLogoutServices, boolean wantAuthnRequestsSigned, boolean wantAssertionsSigned, boolean wantAssertionsEncrypted, String entityId, String nameIDPolicyFormat, List<KeyDescriptorType> signingCerts, List<KeyDescriptorType> encryptionCerts) {
        return SPMetadataDescriptor.buildSPDescriptor(assertionConsumerServices, singleLogoutServices, wantAuthnRequestsSigned, wantAssertionsSigned, wantAssertionsEncrypted, entityId, nameIDPolicyFormat, signingCerts, encryptionCerts, null);
    }

    public static EntityDescriptorType buildSPDescriptor(List<EndpointType> assertionConsumerServices, List<EndpointType> singleLogoutServices, boolean wantAuthnRequestsSigned, boolean wantAssertionsSigned, boolean wantAssertionsEncrypted, String entityId, String nameIDPolicyFormat, List<KeyDescriptorType> signingCerts, List<KeyDescriptorType> encryptionCerts, Long expiration) {
        EntityDescriptorType entityDescriptor = new EntityDescriptorType(entityId);
        entityDescriptor.setID(IDGenerator.create("ID_"));
        if (expiration != null && expiration > 0L) {
            try {
                Duration cacheDuration = DatatypeFactory.newInstance().newDuration(TimeUnit.SECONDS.toMillis(expiration));
                entityDescriptor.setCacheDuration(cacheDuration);
            }
            catch (DatatypeConfigurationException e) {
                throw new RuntimeException("Cannot create datatype factory to create duration", e);
            }
        }
        SPSSODescriptorType spSSODescriptor = new SPSSODescriptorType(Arrays.asList(JBossSAMLURIConstants.PROTOCOL_NSURI.get()));
        spSSODescriptor.setAuthnRequestsSigned(Boolean.valueOf(wantAuthnRequestsSigned));
        spSSODescriptor.setWantAssertionsSigned(Boolean.valueOf(wantAssertionsSigned));
        spSSODescriptor.addNameIDFormat(nameIDPolicyFormat);
        singleLogoutServices.forEach(arg_0 -> ((SPSSODescriptorType)spSSODescriptor).addSingleLogoutService(arg_0));
        if (wantAuthnRequestsSigned && signingCerts != null) {
            for (KeyDescriptorType key : signingCerts) {
                spSSODescriptor.addKeyDescriptor(key);
            }
        }
        if (wantAssertionsEncrypted && encryptionCerts != null) {
            for (KeyDescriptorType key : encryptionCerts) {
                spSSODescriptor.addKeyDescriptor(key);
            }
        }
        ListIterator<EndpointType> iter = assertionConsumerServices.listIterator();
        while (iter.hasNext()) {
            EndpointType endpoint = iter.next();
            IndexedEndpointType assertionConsumerService = new IndexedEndpointType(endpoint.getBinding(), endpoint.getLocation());
            assertionConsumerService.setIndex(iter.nextIndex());
            assertionConsumerService.setIsDefault(iter.nextIndex() == 1 ? Boolean.TRUE : null);
            spSSODescriptor.addAssertionConsumerService(assertionConsumerService);
        }
        entityDescriptor.addChoiceType(new EntityDescriptorType.EDTChoiceType(Arrays.asList(new EntityDescriptorType.EDTDescriptorChoiceType((SSODescriptorType)spSSODescriptor))));
        return entityDescriptor;
    }

    public static KeyDescriptorType buildKeyDescriptorType(Element keyInfo, KeyTypes use, String ... algorithm) {
        KeyDescriptorType keyDescriptor = new KeyDescriptorType();
        keyDescriptor.setUse(use);
        keyDescriptor.setKeyInfo(keyInfo);
        if (algorithm != null) {
            for (String alg : algorithm) {
                EncryptionMethodType encMethod = new EncryptionMethodType(alg);
                keyDescriptor.addEncryptionMethod(encMethod);
            }
        }
        return keyDescriptor;
    }

    public static Element buildKeyInfoElement(String keyName, String pemEncodedCertificate) throws ParserConfigurationException {
        DocumentBuilder db = DocumentUtil.getDocumentBuilder();
        Document doc = db.newDocument();
        Element keyInfo = doc.createElementNS(JBossSAMLURIConstants.XMLDSIG_NSURI.get(), "ds:KeyInfo");
        if (keyName != null) {
            Element keyNameElement = doc.createElementNS(JBossSAMLURIConstants.XMLDSIG_NSURI.get(), "ds:KeyName");
            keyNameElement.setTextContent(keyName);
            keyInfo.appendChild(keyNameElement);
        }
        Element x509Data = doc.createElementNS(JBossSAMLURIConstants.XMLDSIG_NSURI.get(), "ds:X509Data");
        Element x509Certificate = doc.createElementNS(JBossSAMLURIConstants.XMLDSIG_NSURI.get(), "ds:X509Certificate");
        x509Certificate.setTextContent(pemEncodedCertificate);
        x509Data.appendChild(x509Certificate);
        keyInfo.appendChild(x509Data);
        return keyInfo;
    }
}

