// Copyright 2020, 2023, NVIDIA CORPORATION. All rights reserved.
//
// NVIDIA CORPORATION and its licensors retain all intellectual property
// and proprietary rights in and to this software, related documentation
// and any modifications thereto.  Any use, reproduction, disclosure or
// distribution of this software and related documentation without an express
// license agreement from NVIDIA CORPORATION is strictly prohibited.

#pragma once

// Which implementation of C++17 parallel algorithms should be used?

#if !defined(_NVHPC_STDPAR_MULTICORE) && !defined(_NVHPC_STDPAR_GPU) && \
    !defined(_NVHPC_STDPAR_NONE) && \
    __GNUC__ >= 9 && __cplusplus >= 201703L && __has_include(<tbb/tbb.h>)
  #define _NVHPC_STDPAR_USE_GCC 1
#else
  #define _NVHPC_STDPAR_USE_NV 1
#endif
