/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequences;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.PrecisionModel;

public class LinearRing
extends LineString {
    public static final int MINIMUM_VALID_SIZE = 4;
    private static final long serialVersionUID = -4261142084085851829L;

    public LinearRing(Coordinate[] points, PrecisionModel precisionModel, int SRID) {
        this(points, new GeometryFactory(precisionModel, SRID));
        this.validateConstruction();
    }

    private LinearRing(Coordinate[] points, GeometryFactory factory) {
        this(factory.getCoordinateSequenceFactory().create(points), factory);
    }

    public LinearRing(CoordinateSequence points, GeometryFactory factory) {
        super(points, factory);
        this.validateConstruction();
    }

    private void validateConstruction() {
        if (!this.isEmpty() && !super.isClosed()) {
            throw new IllegalArgumentException("Points of LinearRing do not form a closed linestring");
        }
        if (this.getCoordinateSequence().size() >= 1 && this.getCoordinateSequence().size() < 4) {
            throw new IllegalArgumentException("Invalid number of points in LinearRing (found " + this.getCoordinateSequence().size() + " - must be 0 or >= 4)");
        }
    }

    public int getBoundaryDimension() {
        return -1;
    }

    public boolean isClosed() {
        if (this.isEmpty()) {
            return true;
        }
        return super.isClosed();
    }

    public String getGeometryType() {
        return "LinearRing";
    }

    protected int getSortIndex() {
        return 3;
    }

    public LinearRing copy() {
        return new LinearRing(this.points.copy(), this.factory);
    }

    public Geometry reverse() {
        CoordinateSequence seq = this.points.copy();
        CoordinateSequences.reverse(seq);
        LinearRing rev = this.getFactory().createLinearRing(seq);
        return rev;
    }
}

