/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.AbstractKnnCollector;
import org.apache.lucene.search.AbstractVectorSimilarityQuery;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TotalHits;

class VectorSimilarityCollector
extends AbstractKnnCollector {
    private final float traversalSimilarity;
    private final float resultSimilarity;
    private float maxSimilarity;
    private final List<ScoreDoc> scoreDocList;

    public VectorSimilarityCollector(float traversalSimilarity, float resultSimilarity, long visitLimit) {
        super(1, visitLimit, AbstractVectorSimilarityQuery.DEFAULT_STRATEGY);
        if (traversalSimilarity > resultSimilarity) {
            throw new IllegalArgumentException("traversalSimilarity should be <= resultSimilarity");
        }
        this.traversalSimilarity = traversalSimilarity;
        this.resultSimilarity = resultSimilarity;
        this.maxSimilarity = Float.NEGATIVE_INFINITY;
        this.scoreDocList = new ArrayList<ScoreDoc>();
    }

    @Override
    public boolean collect(int docId, float similarity) {
        this.maxSimilarity = Math.max(this.maxSimilarity, similarity);
        if (similarity >= this.resultSimilarity) {
            this.scoreDocList.add(new ScoreDoc(docId, similarity));
        }
        return true;
    }

    @Override
    public float minCompetitiveSimilarity() {
        return Math.min(this.traversalSimilarity, this.maxSimilarity);
    }

    @Override
    public TopDocs topDocs() {
        TotalHits.Relation relation = this.earlyTerminated() ? TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO : TotalHits.Relation.EQUAL_TO;
        return new TopDocs(new TotalHits(this.visitedCount(), relation), (ScoreDoc[])this.scoreDocList.toArray(ScoreDoc[]::new));
    }

    @Override
    public int numCollected() {
        return this.scoreDocList.size();
    }
}

