/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.task.shard;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.persistent.PersistentTaskState;
import org.opensearch.replication.task.ReplicationState;
import org.opensearch.replication.task.shard.CompletedState;
import org.opensearch.replication.task.shard.FailedState;
import org.opensearch.replication.task.shard.FollowingState;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00142\u00020\u0001:\u0002\u0014\u0015B\u0011\b\u0014\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u0082\u0001\u0003\u0016\u0017\u0018\u00a8\u0006\u0019"}, d2={"Lorg/opensearch/replication/task/shard/ShardReplicationState;", "Lorg/opensearch/persistent/PersistentTaskState;", "state", "Lorg/opensearch/replication/task/ReplicationState;", "<init>", "(Lorg/opensearch/replication/task/ReplicationState;)V", "getState", "()Lorg/opensearch/replication/task/ReplicationState;", "setState", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "getWriteableName", "", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "Companion", "Builder", "Lorg/opensearch/replication/task/shard/CompletedState;", "Lorg/opensearch/replication/task/shard/FailedState;", "Lorg/opensearch/replication/task/shard/FollowingState;", "opensearch-cross-cluster-replication"})
public abstract sealed class ShardReplicationState
implements PersistentTaskState
permits CompletedState, FailedState, FollowingState {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private ReplicationState state;
    @NotNull
    public static final String NAME = "cluster:indices/shards/replication";
    @NotNull
    private static final ObjectParser<Builder, Void> PARSER = new ObjectParser("cluster:indices/shards/replication", true, ShardReplicationState::PARSER$lambda$0);

    @NotNull
    public final ReplicationState getState() {
        return this.state;
    }

    public final void setState(@NotNull ReplicationState replicationState) {
        Intrinsics.checkNotNullParameter((Object)((Object)replicationState), (String)"<set-?>");
        this.state = replicationState;
    }

    private ShardReplicationState(ReplicationState state) {
        this.state = state;
    }

    public void writeTo(@NotNull StreamOutput out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeEnum((Enum)this.state);
    }

    @NotNull
    public String getWriteableName() {
        return NAME;
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @Nullable ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        XContentBuilder xContentBuilder = builder.startObject().field("state", (ToXContent)this.state).endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"endObject(...)");
        return xContentBuilder;
    }

    private static final Builder PARSER$lambda$0() {
        return new Builder();
    }

    public /* synthetic */ ShardReplicationState(ReplicationState state, DefaultConstructorMarker $constructor_marker) {
        this(state);
    }

    static {
        PARSER.declareString(Builder::setShardTaskState, new ParseField("state", new String[0]));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\f\u001a\u00020\rR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lorg/opensearch/replication/task/shard/ShardReplicationState$Builder;", "", "<init>", "()V", "state", "", "getState", "()Ljava/lang/String;", "setState", "(Ljava/lang/String;)V", "setShardTaskState", "", "build", "Lorg/opensearch/replication/task/shard/ShardReplicationState;", "opensearch-cross-cluster-replication"})
    public static final class Builder {
        public String state;

        @NotNull
        public final String getState() {
            String string = this.state;
            if (string != null) {
                return string;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"state");
            return null;
        }

        public final void setState(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.state = string;
        }

        public final void setShardTaskState(@NotNull String state) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            this.setState(state);
        }

        @NotNull
        public final ShardReplicationState build() {
            this.setState(this.state == null ? "FOLLOWING" : this.getState());
            return switch (this.getState()) {
                case "INIT" -> throw new IllegalArgumentException("INIT - Illegal state for shard replication task");
                case "RESTORING" -> throw new IllegalArgumentException("RESTORING - Illegal state for shard replication task");
                case "INIT_FOLLOW" -> throw new IllegalArgumentException("INIT_FOLLOW - Illegal state for shard replication task");
                case "FOLLOWING" -> FollowingState.INSTANCE;
                case "COMPLETED" -> CompletedState.INSTANCE;
                case "FAILED" -> new FailedState(null);
                default -> throw new IllegalArgumentException(this.getState() + " - Not a valid state for shard replication task");
            };
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/opensearch/replication/task/shard/ShardReplicationState$Companion;", "", "<init>", "()V", "NAME", "", "reader", "Lorg/opensearch/replication/task/shard/ShardReplicationState;", "inp", "Lorg/opensearch/core/common/io/stream/StreamInput;", "PARSER", "Lorg/opensearch/core/xcontent/ObjectParser;", "Lorg/opensearch/replication/task/shard/ShardReplicationState$Builder;", "Ljava/lang/Void;", "fromXContent", "parser", "Lorg/opensearch/core/xcontent/XContentParser;", "opensearch-cross-cluster-replication"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ShardReplicationState reader(@NotNull StreamInput inp) {
            Intrinsics.checkNotNullParameter((Object)inp, (String)"inp");
            Enum enum_ = inp.readEnum(ReplicationState.class);
            Intrinsics.checkNotNull((Object)enum_);
            ReplicationState state = (ReplicationState)enum_;
            return switch (WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                case 1 -> throw new IllegalStateException("INIT - Illegal state for shard replication task");
                case 2 -> throw new IllegalStateException("RESTORING - Illegal state for shard replication task");
                case 3 -> throw new IllegalStateException("INIT_FOLLOW - Illegal state for shard replication task");
                case 4 -> FollowingState.INSTANCE;
                case 5 -> new FailedState(inp);
                case 6 -> CompletedState.INSTANCE;
                default -> throw new IllegalArgumentException(state + " - Not a valid state for shard replication task");
            };
        }

        @NotNull
        public final ShardReplicationState fromXContent(@NotNull XContentParser parser) throws IOException {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            return ((Builder)PARSER.parse(parser, null)).build();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ReplicationState.values().length];
                try {
                    nArray[ReplicationState.INIT.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ReplicationState.RESTORING.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ReplicationState.INIT_FOLLOW.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ReplicationState.FOLLOWING.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ReplicationState.FAILED.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ReplicationState.COMPLETED.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

