/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.nodes.stats.MemoryStatsBase;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ExtendedMemoryStats
extends MemoryStatsBase
implements ToCopyableBuilder<Builder, ExtendedMemoryStats> {
    @Nullable
    private final Double freePercent;
    @Nullable
    private final Double usedPercent;
    public static final JsonpDeserializer<ExtendedMemoryStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ExtendedMemoryStats::setupExtendedMemoryStatsDeserializer);

    private ExtendedMemoryStats(Builder builder) {
        super(builder);
        this.freePercent = builder.freePercent;
        this.usedPercent = builder.usedPercent;
    }

    public static ExtendedMemoryStats of(Function<Builder, ObjectBuilder<ExtendedMemoryStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Double freePercent() {
        return this.freePercent;
    }

    @Nullable
    public final Double usedPercent() {
        return this.usedPercent;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.freePercent != null) {
            generator.writeKey("free_percent");
            generator.write(this.freePercent.doubleValue());
        }
        if (this.usedPercent != null) {
            generator.writeKey("used_percent");
            generator.write(this.usedPercent.doubleValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupExtendedMemoryStatsDeserializer(ObjectDeserializer<Builder> op) {
        ExtendedMemoryStats.setupMemoryStatsBaseDeserializer(op);
        op.add(Builder::freePercent, JsonpDeserializer.doubleDeserializer(), "free_percent");
        op.add(Builder::usedPercent, JsonpDeserializer.doubleDeserializer(), "used_percent");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.freePercent);
        result = 31 * result + Objects.hashCode(this.usedPercent);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtendedMemoryStats other = (ExtendedMemoryStats)o;
        return Objects.equals(this.freePercent, other.freePercent) && Objects.equals(this.usedPercent, other.usedPercent);
    }

    public static class Builder
    extends MemoryStatsBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, ExtendedMemoryStats> {
        @Nullable
        private Double freePercent;
        @Nullable
        private Double usedPercent;

        public Builder() {
        }

        private Builder(ExtendedMemoryStats o) {
            super(o);
            this.freePercent = o.freePercent;
            this.usedPercent = o.usedPercent;
        }

        private Builder(Builder o) {
            super(o);
            this.freePercent = o.freePercent;
            this.usedPercent = o.usedPercent;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder freePercent(@Nullable Double value) {
            this.freePercent = value;
            return this;
        }

        @Nonnull
        public final Builder usedPercent(@Nullable Double value) {
            this.usedPercent = value;
            return this;
        }

        @Override
        @Nonnull
        public ExtendedMemoryStats build() {
            this._checkSingleUse();
            return new ExtendedMemoryStats(this);
        }
    }
}

