/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.checksums;

import java.util.zip.Checksum;
import software.amazon.awssdk.crt.CRT;

public class CRC32
implements Checksum,
Cloneable {
    private int value = 0;

    public CRC32() {
    }

    private CRC32(int value) {
        this.value = value;
    }

    public Object clone() {
        return new CRC32(this.value);
    }

    @Override
    public long getValue() {
        return (long)this.value & 0xFFFFFFFFL;
    }

    @Override
    public void reset() {
        this.value = 0;
    }

    @Override
    public void update(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.value = CRC32.crc32(b, this.value, off, len);
    }

    @Override
    public void update(byte[] b) {
        this.update(b, 0, b.length);
    }

    @Override
    public void update(int b) {
        if (b < 0 || b > 255) {
            throw new IllegalArgumentException();
        }
        byte[] buf = new byte[]{(byte)(b & 0xFF)};
        this.update(buf);
    }

    private static native int crc32(byte[] var0, int var1, int var2, int var3);

    static {
        new CRT();
    }
}

