/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.yaml.parser;

import java.util.List;
import net.sourceforge.plantuml.utils.Peeker;
import net.sourceforge.plantuml.utils.PeekerUtils;
import net.sourceforge.plantuml.yaml.parser.IndentationStack;
import net.sourceforge.plantuml.yaml.parser.Monomorph;
import net.sourceforge.plantuml.yaml.parser.YamlBuilder;
import net.sourceforge.plantuml.yaml.parser.YamlLine;
import net.sourceforge.plantuml.yaml.parser.YamlLineType;
import net.sourceforge.plantuml.yaml.parser.YamlSyntaxException;

public class YamlParser {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Monomorph parse(List<String> lines) {
        IndentationStack indentationStack = new IndentationStack();
        YamlBuilder yamlBuilder = new YamlBuilder();
        Peeker<String> peeker = PeekerUtils.peeker(lines);
        while (peeker.peek(0) != null) {
            YamlLine yamlLine = YamlLine.build(peeker.peek(0));
            if (yamlLine.getType() != YamlLineType.EMPTY_LINE) {
                if (yamlLine.getType() == YamlLineType.NO_KEY_ONLY_TEXT) {
                    throw new YamlSyntaxException("YamlLineType.NO_KEY_ONLY_TEXT");
                }
                if (yamlLine.getType() == YamlLineType.PLAIN_DASH) {
                    yamlBuilder.onListItemPlainDash();
                } else {
                    if (indentationStack.size() == 0) {
                        indentationStack.push(yamlLine.getIndent());
                    }
                    if (yamlLine.getIndent() > indentationStack.peek()) {
                        yamlBuilder.increaseIndentation();
                        indentationStack.push(yamlLine.getIndent());
                    } else {
                        while (yamlLine.getIndent() < indentationStack.peek()) {
                            yamlBuilder.decreaseIndentation();
                            indentationStack.pop();
                        }
                    }
                    if (yamlLine.getIndent() != indentationStack.peek()) throw new UnsupportedOperationException("wip5 " + yamlLine);
                    if (yamlLine.isListItem()) {
                        if (yamlLine.getType() == YamlLineType.KEY_ONLY) {
                            yamlBuilder.onListItemOnlyKey(yamlLine.getKey());
                        } else if (yamlLine.getType() == YamlLineType.PLAIN_ELEMENT_LIST) {
                            yamlBuilder.onListItemOnlyValue(yamlLine.getValue());
                        } else if (yamlLine.getType() == YamlLineType.KEY_AND_VALUE) {
                            yamlBuilder.onListItemKeyAndValue(yamlLine.getKey(), yamlLine.getValue());
                        } else {
                            if (yamlLine.getType() != YamlLineType.KEY_AND_FLOW_SEQUENCE) throw new UnsupportedOperationException("wip3 " + yamlLine);
                            yamlBuilder.onListItemKeyAndFlowSequence(yamlLine.getKey(), yamlLine.getValues());
                        }
                    } else if (yamlLine.getType() == YamlLineType.KEY_ONLY) {
                        YamlLine next = this.peekNext(peeker);
                        if (next == null || next.getIndent() <= yamlLine.getIndent()) {
                            yamlBuilder.onKeyAndValue(yamlLine.getKey(), "");
                        } else if (next.getType() == YamlLineType.NO_KEY_ONLY_TEXT) {
                            yamlBuilder.onKeyAndValue(yamlLine.getKey(), this.peekNextOnlyText(peeker));
                        } else {
                            yamlBuilder.onOnlyKey(yamlLine.getKey());
                        }
                    } else if (yamlLine.getType() == YamlLineType.KEY_AND_VALUE) {
                        yamlBuilder.onKeyAndValue(yamlLine.getKey(), yamlLine.getValue());
                    } else if (yamlLine.getType() == YamlLineType.KEY_AND_BLOCK_STYLE) {
                        yamlBuilder.onKeyAndValue(yamlLine.getKey(), this.getBlockStyleString(yamlLine.getIndent(), peeker));
                    } else {
                        if (yamlLine.getType() != YamlLineType.KEY_AND_FLOW_SEQUENCE) throw new UnsupportedOperationException("wip4 " + yamlLine);
                        yamlBuilder.onKeyAndFlowSequence(yamlLine.getKey(), yamlLine.getValues());
                    }
                }
            }
            peeker.jump();
        }
        return yamlBuilder.getResult();
    }

    private String peekNextOnlyText(Peeker<String> peeker) {
        StringBuilder result = new StringBuilder();
        while (true) {
            String peek;
            if ((peek = peeker.peek(1)) == null) {
                return result.toString();
            }
            YamlLine next = YamlLine.build(peek);
            if (next != null && next.getType() == YamlLineType.EMPTY_LINE) {
                peeker.jump();
                continue;
            }
            if (next.getType() != YamlLineType.NO_KEY_ONLY_TEXT) break;
            if (result.length() > 0) {
                result.append(" ");
            }
            result.append(next.getValue());
            peeker.jump();
        }
        return result.toString();
    }

    private YamlLine peekNext(Peeker<String> peeker) {
        YamlLine next;
        int i = 1;
        while (true) {
            String peek;
            if ((peek = peeker.peek(i)) == null) {
                return null;
            }
            next = YamlLine.build(peek);
            if (next == null || next.getType() != YamlLineType.EMPTY_LINE) break;
            ++i;
        }
        return next;
    }

    private String getBlockStyleString(int indent, Peeker<String> peeker) {
        StringBuilder result = new StringBuilder();
        while (peeker.peek(1) != null) {
            String line = peeker.peek(1);
            if (line == null) {
                return result.toString();
            }
            YamlLine yamlLine = YamlLine.build(line);
            if (yamlLine.getType() != YamlLineType.NO_KEY_ONLY_TEXT && yamlLine.getType() != YamlLineType.EMPTY_LINE && yamlLine.getIndent() <= indent) {
                return result.toString();
            }
            result.append(YamlParser.cleanBlockStyle(indent, line));
            result.append("\n");
            peeker.jump();
        }
        return result.toString();
    }

    private static String cleanBlockStyle(int indent, String s) {
        return s.trim();
    }
}

