/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.semanticweb.owlapi.io.OWLParserFactory;
import org.semanticweb.owlapi.util.PriorityCollection;

public class AcceptHeaderBuilder {
    public static String headersFromParsers(PriorityCollection<OWLParserFactory> parsers) {
        HashMap map = new HashMap();
        parsers.forEach(p -> AcceptHeaderBuilder.addToMap(map, p.getMIMETypes()));
        return map.entrySet().stream().sorted(AcceptHeaderBuilder::compare).map(AcceptHeaderBuilder::tostring).collect(Collectors.joining(", "));
    }

    private static void addToMap(Map<String, TreeSet<Integer>> map, List<String> mimes) {
        for (int i = 0; i < mimes.size(); ++i) {
            map.computeIfAbsent(mimes.get(i), k -> new TreeSet()).add(i + 1);
        }
    }

    private static String tostring(Map.Entry<String, TreeSet<Integer>> e) {
        return String.format("%s; q=%.1f", e.getKey(), 1.0 / (double)e.getValue().first().intValue());
    }

    private static int compare(Map.Entry<String, TreeSet<Integer>> a, Map.Entry<String, TreeSet<Integer>> b) {
        return a.getValue().first().compareTo(b.getValue().first());
    }
}

