/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.core.nio.fs;

import com.intellij.platform.core.nio.fs.DelegatingFileSystem;
import com.intellij.platform.core.nio.fs.DelegatingFileSystemProvider;
import com.intellij.platform.core.nio.fs.FileSystemTracingListener;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public abstract class TracingFileSystemProvider<P extends TracingFileSystemProvider<P, F>, F extends DelegatingFileSystem<P>>
extends DelegatingFileSystemProvider<P, F> {
    private FileSystemTracingListener<Object> myListener = new FileSystemTracingListener.NoopFileSystemTracingListener();

    public void setTraceListener(FileSystemTracingListener<?> listener) {
        this.myListener = listener;
    }

    @Override
    public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) throws IOException {
        FileSystemProvider delegate = this.getDelegate(link, target);
        Object token = this.myListener.providerCreateSymbolicLinkStarted(delegate, link, target, attrs);
        try {
            delegate.createSymbolicLink(this.toDelegatePath(link), this.toDelegatePath(target), attrs);
            this.myListener.providerGenericReturn(token);
        }
        catch (Throwable err) {
            this.myListener.providerGenericError(delegate, err);
            throw err;
        }
    }

    @Override
    public void createLink(Path link, Path existing) throws IOException {
        FileSystemProvider delegate = this.getDelegate(link, existing);
        Object token = this.myListener.providerCreateLinkStarted(delegate, link, existing);
        try {
            delegate.createLink(this.toDelegatePath(link), this.toDelegatePath(existing));
            this.myListener.providerGenericReturn(token);
        }
        catch (Throwable err) {
            this.myListener.providerGenericError(delegate, err);
            throw err;
        }
    }

    @Override
    public boolean deleteIfExists(Path path) throws IOException {
        FileSystemProvider delegate = this.getDelegate(path, null);
        Object token = this.myListener.providerDeleteIfExistsStarted(delegate, path);
        try {
            boolean result = delegate.deleteIfExists(this.toDelegatePath(path));
            this.myListener.providerGenericReturn(token);
            return result;
        }
        catch (Throwable err) {
            this.myListener.providerGenericError(delegate, err);
            throw err;
        }
    }

    @Override
    public Path readSymbolicLink(Path link) throws IOException {
        FileSystemProvider delegate = this.getDelegate(link, null);
        Object token = this.myListener.providerReadSymbolicLinkStarted(delegate, link);
        try {
            Path result = this.wrapDelegatePath(delegate.readSymbolicLink(this.toDelegatePath(link)));
            this.myListener.providerGenericReturn(token);
            return result;
        }
        catch (Throwable err) {
            this.myListener.providerGenericError(delegate, err);
            throw err;
        }
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        FileSystemProvider delegate = this.getDelegate(path, null);
        Object token = this.myListener.providerNewByteChannelStarted(delegate, path, options, attrs);
        try {
            SeekableByteChannel result = delegate.newByteChannel(this.toDelegatePath(path), options, attrs);
            SeekableByteChannel wrappedResult = this.myListener.providerNewByteChannelReturn(token, result);
            return wrappedResult;
        }
        catch (Throwable err) {
            this.myListener.providerGenericError(token, err);
            throw err;
        }
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, @Nullable DirectoryStream.Filter<? super Path> filter) throws IOException {
        FileSystemProvider delegate = this.getDelegate(dir, null);
        Object token = this.myListener.providerNewDirectoryStreamStarted(delegate, dir, filter);
        try {
            DirectoryStream<Path> result = this.delegateNewDirectoryStream(delegate, dir, filter);
            DirectoryStream<Path> wrappedResult = this.myListener.providerNewDirectoryStreamReturn(token, result);
            return wrappedResult;
        }
        catch (Throwable err) {
            this.myListener.providerGenericError(token, err);
            throw err;
        }
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        FileSystemProvider delegate = this.getDelegate(dir, null);
        Object token = this.myListener.providerCreateDirectoryStarted(delegate, dir, attrs);
        try {
            delegate.createDirectory(this.toDelegatePath(dir), attrs);
            this.myListener.providerGenericReturn(token);
        }
        catch (Throwable err) {
            this.myListener.providerGenericError(token, err);
            throw err;
        }
    }

    @Override
    public void delete(Path path) throws IOException {
        FileSystemProvider delegate = this.getDelegate(path, null);
        Object token = this.myListener.providerDeleteStarted(delegate, path);
        try {
            delegate.delete(this.toDelegatePath(path));
            this.myListener.providerGenericReturn(token);
        }
        catch (Throwable err) {
            this.myListener.providerGenericError(token, err);
            throw err;
        }
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        FileSystemProvider delegate = this.getDelegate(source, target);
        Object token = this.myListener.providerCopyStarted(delegate, source, target, options);
        try {
            delegate.copy(this.toDelegatePath(source), this.toDelegatePath(target), options);
            this.myListener.providerGenericReturn(token);
        }
        catch (Throwable err) {
            this.myListener.providerGenericError(token, err);
            throw err;
        }
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        FileSystemProvider delegate = this.getDelegate(source, target);
        Object token = this.myListener.providerMoveStarted(delegate, source, target, options);
        try {
            delegate.move(this.toDelegatePath(source), this.toDelegatePath(target), options);
            this.myListener.providerGenericReturn(token);
        }
        catch (Throwable err) {
            this.myListener.providerGenericError(token, err);
            throw err;
        }
    }

    @Override
    public boolean isSameFile(Path path, Path path2) throws IOException {
        FileSystemProvider delegate = this.getDelegate(path, path2);
        Object token = this.myListener.providerIsSameFileStarted(delegate, path, path2);
        try {
            boolean result = delegate.isSameFile(this.toDelegatePath(path), this.toDelegatePath(path2));
            this.myListener.providerGenericReturn(token);
            return result;
        }
        catch (Throwable err) {
            this.myListener.providerGenericError(token, err);
            throw err;
        }
    }

    @Override
    public boolean isHidden(Path path) throws IOException {
        FileSystemProvider delegate = this.getDelegate(path, null);
        Object token = this.myListener.providerIsHiddenStarted(delegate, path);
        try {
            boolean result = delegate.isHidden(this.toDelegatePath(path));
            this.myListener.providerGenericReturn(token);
            return result;
        }
        catch (Throwable err) {
            this.myListener.providerGenericError(token, err);
            throw err;
        }
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        FileSystemProvider delegate = this.getDelegate(path, null);
        Object token = this.myListener.providerGetFileStoreStarted(delegate, path);
        try {
            FileStore result = delegate.getFileStore(this.toDelegatePath(path));
            this.myListener.providerGenericReturn(token);
            return result;
        }
        catch (Throwable err) {
            this.myListener.providerGenericError(token, err);
            throw err;
        }
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        FileSystemProvider delegate = this.getDelegate(path, null);
        Object token = this.myListener.providerCheckAccessStarted(delegate, path, modes);
        try {
            delegate.checkAccess(this.toDelegatePath(path), modes);
            this.myListener.providerGenericReturn(token);
        }
        catch (Throwable err) {
            this.myListener.providerGenericError(token, err);
            throw err;
        }
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        FileSystemProvider delegate = this.getDelegate(path, null);
        Object token = this.myListener.providerGetFileAttributeViewStarted(delegate, path, type, options);
        try {
            V result = delegate.getFileAttributeView(this.toDelegatePath(path), type, options);
            this.myListener.providerGenericReturn(token);
            return result;
        }
        catch (Throwable err) {
            this.myListener.providerGenericError(token, err);
            throw err;
        }
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        FileSystemProvider delegate = this.getDelegate(path, null);
        Object token = this.myListener.providerReadAttributesStarted(delegate, path, type, options);
        try {
            A result = delegate.readAttributes(this.toDelegatePath(path), type, options);
            this.myListener.providerGenericReturn(token);
            return result;
        }
        catch (Throwable err) {
            this.myListener.providerGenericError(token, err);
            throw err;
        }
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        FileSystemProvider delegate = this.getDelegate(path, null);
        Object token = this.myListener.providerReadAttributesStarted(delegate, path, attributes, options);
        try {
            Map<String, Object> result = delegate.readAttributes(this.toDelegatePath(path), attributes, options);
            this.myListener.providerGenericReturn(token);
            return result;
        }
        catch (Throwable err) {
            this.myListener.providerGenericError(token, err);
            throw err;
        }
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        FileSystemProvider delegate = this.getDelegate(path, null);
        Object token = this.myListener.providerSetAttributeStarted(delegate, path, attribute, value, options);
        try {
            delegate.setAttribute(this.toDelegatePath(path), attribute, value, options);
            this.myListener.providerGenericReturn(token);
        }
        catch (Throwable err) {
            this.myListener.providerGenericError(token, err);
            throw err;
        }
    }
}

