/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.InterruptedIOException;
import java.lang.reflect.Executable;
import java.nio.channels.SocketChannel;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

public final class TimeoutInterruptHandler {
    private static final Timer INTERRUPT_TIMER;
    static ConcurrentHashMap<Thread, InterruptTask> outboundTimerTasksHash;
    static ConcurrentHashMap<Thread, InterruptTask> soTimerTasksHash;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;

    private TimeoutInterruptHandler() {
    }

    public static InterruptTask scheduleInterrupt(InterruptTaskType taskType, int time, Thread threadTobeInterrupted, SocketChannel socketChannel, boolean sendAttn) {
        if (time <= 0) {
            return null;
        }
        ConcurrentHashMap<Thread, InterruptTask> taskMap = TimeoutInterruptHandler.getMap(taskType);
        InterruptTask interruptTask = (InterruptTask)taskMap.get(threadTobeInterrupted);
        if (interruptTask != null) {
            String debugStr = "Interrupt task is already scheduled for the thread " + threadTobeInterrupted.getId() + " and the type " + (Object)((Object)taskType) + " for SocketChannel = " + socketChannel;
            throw new IllegalStateException(debugStr);
        }
        interruptTask = new InterruptTask(threadTobeInterrupted, time, socketChannel, sendAttn);
        INTERRUPT_TIMER.schedule((TimerTask)interruptTask, time);
        taskMap.put(Thread.currentThread(), interruptTask);
        return interruptTask;
    }

    public static InterruptTask scheduleInterrupt(InterruptTaskType taskType, int time, Thread threadTobeInterrupted, SocketChannel socketChannel) {
        return TimeoutInterruptHandler.scheduleInterrupt(taskType, time, threadTobeInterrupted, socketChannel, false);
    }

    public static InterruptTask scheduleInterrupt(InterruptTaskType taskType, int time, Thread threadTobeInterrupted) {
        return TimeoutInterruptHandler.scheduleInterrupt(taskType, time, threadTobeInterrupted, null);
    }

    public static InterruptTask cancelInterrupt(InterruptTaskType taskType, Thread threadTobeInterrupted) {
        ConcurrentHashMap<Thread, InterruptTask> taskMap = TimeoutInterruptHandler.getMap(taskType);
        InterruptTask interruptTask = (InterruptTask)taskMap.remove(threadTobeInterrupted);
        if (interruptTask != null) {
            interruptTask.cancel();
            INTERRUPT_TIMER.purge();
        }
        return interruptTask;
    }

    public static InterruptTask cancelInterrupt(InterruptTaskType taskType, SocketChannel socketChannel) {
        ConcurrentHashMap<Thread, InterruptTask> taskMap = TimeoutInterruptHandler.getMap(taskType);
        InterruptTask interruptTask = taskMap.searchValues(1L, task -> task.isSocketChannel(socketChannel) ? task : null);
        if (interruptTask == null) {
            return null;
        }
        taskMap.remove(interruptTask.getThread());
        interruptTask.cancel();
        INTERRUPT_TIMER.purge();
        return interruptTask;
    }

    public static boolean isInterruptScheduled(InterruptTaskType taskType, Thread threadTobeInterrupted) {
        ConcurrentHashMap<Thread, InterruptTask> taskMap = TimeoutInterruptHandler.getMap(taskType);
        return taskMap.get(threadTobeInterrupted) != null;
    }

    public static void resetTimer(InterruptTaskType taskType, Thread threadTobeInterrupted) {
        ConcurrentHashMap<Thread, InterruptTask> taskMap = TimeoutInterruptHandler.getMap(taskType);
        InterruptTask interruptTask = TimeoutInterruptHandler.cancelInterrupt(taskType, threadTobeInterrupted);
        if (interruptTask != null) {
            if (interruptTask.isInterrupted) {
                Thread.interrupted();
            }
            TimeoutInterruptHandler.scheduleInterrupt(taskType, interruptTask.time, threadTobeInterrupted, interruptTask.socketChannel, interruptTask.sendAttn);
        }
    }

    private static ConcurrentHashMap<Thread, InterruptTask> getMap(InterruptTaskType taskType) {
        if (taskType.compareTo(InterruptTaskType.OUTBOUND_TIMEOUT) == 0) {
            return outboundTimerTasksHash;
        }
        return soTimerTasksHash;
    }

    public static void stopTimer() {
        INTERRUPT_TIMER.cancel();
    }

    public static TimerTask scheduleTask(Runnable task, long msDelay) {
        TimerPurgingTask purgingTask = new TimerPurgingTask(task);
        INTERRUPT_TIMER.schedule((TimerTask)purgingTask, msDelay);
        return purgingTask;
    }

    public static TimerTask scheduleFixedDelayRepeatingTask(Runnable task, long periodOfMilliseconds) {
        TimerPurgingTask purgingTask = new TimerPurgingTask(task);
        INTERRUPT_TIMER.schedule((TimerTask)purgingTask, 0L, periodOfMilliseconds);
        return purgingTask;
    }

    public static void scheduleAtFixedRate(TimerTask task, long delay, long period) {
        INTERRUPT_TIMER.scheduleAtFixedRate(task, delay, period);
    }

    static {
        try {
            $$$methodRef$$$14 = TimeoutInterruptHandler.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = TimeoutInterruptHandler.class.getDeclaredMethod("access$500", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = TimeoutInterruptHandler.class.getDeclaredMethod("lambda$cancelInterrupt$0", SocketChannel.class, InterruptTask.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = TimeoutInterruptHandler.class.getDeclaredMethod("scheduleAtFixedRate", TimerTask.class, Long.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = TimeoutInterruptHandler.class.getDeclaredMethod("scheduleFixedDelayRepeatingTask", Runnable.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = TimeoutInterruptHandler.class.getDeclaredMethod("scheduleTask", Runnable.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = TimeoutInterruptHandler.class.getDeclaredMethod("stopTimer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = TimeoutInterruptHandler.class.getDeclaredMethod("getMap", InterruptTaskType.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = TimeoutInterruptHandler.class.getDeclaredMethod("resetTimer", InterruptTaskType.class, Thread.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = TimeoutInterruptHandler.class.getDeclaredMethod("isInterruptScheduled", InterruptTaskType.class, Thread.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = TimeoutInterruptHandler.class.getDeclaredMethod("cancelInterrupt", InterruptTaskType.class, SocketChannel.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = TimeoutInterruptHandler.class.getDeclaredMethod("cancelInterrupt", InterruptTaskType.class, Thread.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = TimeoutInterruptHandler.class.getDeclaredMethod("scheduleInterrupt", InterruptTaskType.class, Integer.TYPE, Thread.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = TimeoutInterruptHandler.class.getDeclaredMethod("scheduleInterrupt", InterruptTaskType.class, Integer.TYPE, Thread.class, SocketChannel.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = TimeoutInterruptHandler.class.getDeclaredMethod("scheduleInterrupt", InterruptTaskType.class, Integer.TYPE, Thread.class, SocketChannel.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        INTERRUPT_TIMER = new Timer("InterruptTimer", true);
        outboundTimerTasksHash = new ConcurrentHashMap();
        soTimerTasksHash = new ConcurrentHashMap();
    }

    private static final class TimerPurgingTask
    extends TimerTask {
        private final Runnable runnableTask;
        private boolean isPurged = false;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;

        private TimerPurgingTask(Runnable runnableTask) {
            this.runnableTask = runnableTask;
        }

        @Override
        public void run() {
            try {
                this.runnableTask.run();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }

        @Override
        public boolean cancel() {
            boolean isCancelled = super.cancel();
            if (!this.isPurged) {
                INTERRUPT_TIMER.purge();
                this.isPurged = true;
            }
            return isCancelled;
        }

        static {
            try {
                $$$methodRef$$$3 = TimerPurgingTask.class.getDeclaredConstructor(Runnable.class, 1.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = TimerPurgingTask.class.getDeclaredConstructor(Runnable.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = TimerPurgingTask.class.getDeclaredMethod("cancel", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = TimerPurgingTask.class.getDeclaredMethod("run", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    public static class IOReadTimeoutException
    extends InterruptedIOException {
        private static final long serialVersionUID = 1L;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;

        IOReadTimeoutException(String msg) {
            super(msg);
        }

        static {
            try {
                $$$methodRef$$$0 = IOReadTimeoutException.class.getDeclaredConstructor(String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    public static class InterruptTask
    extends TimerTask {
        private final Thread threadTobeInterrupted;
        private boolean isInterrupted = false;
        private final int time;
        private final SocketChannel socketChannel;
        private boolean sendAttn = false;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;
        private static Executable $$$methodRef$$$10;
        private static Logger $$$loggerRef$$$10;

        public InterruptTask(Thread thread, int time, SocketChannel socketChannel) {
            this.threadTobeInterrupted = thread;
            this.time = time;
            this.socketChannel = socketChannel;
        }

        public InterruptTask(Thread thread, int time, SocketChannel socketChannel, boolean sendAttn) {
            this(thread, time, socketChannel);
            this.sendAttn = sendAttn;
        }

        public boolean isInterrupted() {
            return this.isInterrupted;
        }

        public boolean isSocketChannel(SocketChannel socketChannel) {
            return this.socketChannel == socketChannel;
        }

        public Thread getThread() {
            return this.threadTobeInterrupted;
        }

        private void sendAttentionMarker() {
            if (!this.sendAttn) {
                return;
            }
            try {
                this.socketChannel.socket().sendUrgentData(33);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            this.isInterrupted = true;
            this.sendAttentionMarker();
            this.threadTobeInterrupted.interrupt();
        }

        static {
            try {
                $$$methodRef$$$10 = InterruptTask.class.getDeclaredConstructor(Thread.class, Integer.TYPE, SocketChannel.class, Boolean.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$9 = InterruptTask.class.getDeclaredConstructor(Thread.class, Integer.TYPE, SocketChannel.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$8 = InterruptTask.class.getDeclaredMethod("access$300", InterruptTask.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$7 = InterruptTask.class.getDeclaredMethod("access$200", InterruptTask.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$6 = InterruptTask.class.getDeclaredMethod("access$100", InterruptTask.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = InterruptTask.class.getDeclaredMethod("access$000", InterruptTask.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = InterruptTask.class.getDeclaredMethod("run", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = InterruptTask.class.getDeclaredMethod("sendAttentionMarker", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = InterruptTask.class.getDeclaredMethod("getThread", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = InterruptTask.class.getDeclaredMethod("isSocketChannel", SocketChannel.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = InterruptTask.class.getDeclaredMethod("isInterrupted", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    public static final class InterruptTaskType
    extends Enum<InterruptTaskType> {
        public static final /* enum */ InterruptTaskType SO_TIMEOUT;
        public static final /* enum */ InterruptTaskType OUTBOUND_TIMEOUT;
        private static final /* synthetic */ InterruptTaskType[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        public static InterruptTaskType[] values() {
            return (InterruptTaskType[])$VALUES.clone();
        }

        public static InterruptTaskType valueOf(String name) {
            return Enum.valueOf(InterruptTaskType.class, name);
        }

        static {
            try {
                $$$methodRef$$$2 = InterruptTaskType.class.getDeclaredConstructor(String.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = InterruptTaskType.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = InterruptTaskType.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            SO_TIMEOUT = new InterruptTaskType();
            OUTBOUND_TIMEOUT = new InterruptTaskType();
            $VALUES = new InterruptTaskType[]{SO_TIMEOUT, OUTBOUND_TIMEOUT};
        }
    }
}

