/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.fields;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.firebirdsql.encodings.IEncodingFactory;
import org.firebirdsql.gds.ng.DatatypeCoder;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.gds.ng.fields.RowValue;

public final class RowDescriptor
implements Iterable<FieldDescriptor> {
    private static final FieldDescriptor[] NO_DESCRIPTORS = new FieldDescriptor[0];
    private final List<FieldDescriptor> fieldDescriptors;
    private final DatatypeCoder datatypeCoder;
    private int hash;

    private RowDescriptor(FieldDescriptor[] fieldDescriptors, DatatypeCoder datatypeCoder) {
        this.fieldDescriptors = List.of(fieldDescriptors);
        this.datatypeCoder = Objects.requireNonNull(datatypeCoder, "dataTypeCoder should not be null");
    }

    public DatatypeCoder getDatatypeCoder() {
        return this.datatypeCoder;
    }

    public IEncodingFactory getEncodingFactory() {
        return this.datatypeCoder.getEncodingFactory();
    }

    public int getCount() {
        return this.fieldDescriptors.size();
    }

    public FieldDescriptor getFieldDescriptor(int index) {
        return this.fieldDescriptors.get(index);
    }

    public List<FieldDescriptor> getFieldDescriptors() {
        return this.fieldDescriptors;
    }

    public RowValue createDefaultFieldValues() {
        return RowValue.defaultFor(this);
    }

    public RowValue createDeletedRowMarker() {
        return RowValue.deletedRowMarker(this.getCount());
    }

    @Override
    public Iterator<FieldDescriptor> iterator() {
        return this.fieldDescriptors.iterator();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RowDescriptor: [");
        for (int idx = 0; idx < this.fieldDescriptors.size(); ++idx) {
            sb.append(idx).append('=');
            FieldDescriptor descriptor = this.fieldDescriptors.get(idx);
            if (descriptor != null) {
                descriptor.appendFieldDescriptor(sb);
            } else {
                sb.append("[null]");
            }
            sb.append(',');
        }
        if (!this.fieldDescriptors.isEmpty()) {
            sb.setLength(sb.length() - 1);
        }
        sb.append(']');
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RowDescriptor)) {
            return false;
        }
        RowDescriptor other = (RowDescriptor)obj;
        return this.fieldDescriptors.equals(other.fieldDescriptors);
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        int newHash = this.fieldDescriptors.hashCode();
        this.hash = newHash != 0 ? newHash : 1;
        return this.hash;
    }

    public static RowDescriptor createRowDescriptor(FieldDescriptor[] fieldDescriptors, DatatypeCoder datatypeCoder) {
        return new RowDescriptor(fieldDescriptors, datatypeCoder);
    }

    public static RowDescriptor empty(DatatypeCoder datatypeCoder) {
        return new RowDescriptor(NO_DESCRIPTORS, datatypeCoder);
    }
}

