/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.firebirdsql.gds.TransactionParameterBuffer;
import org.firebirdsql.gds.ng.AbstractAttachProperties;
import org.firebirdsql.gds.ng.FbConnectionProperties;
import org.firebirdsql.gds.ng.IConnectionProperties;
import org.firebirdsql.jaybird.props.def.ConnectionProperty;
import org.firebirdsql.jdbc.FBTpbMapper;
import org.firebirdsql.jdbc.FirebirdConnectionProperties;

public final class FBConnectionProperties
implements FirebirdConnectionProperties,
Serializable,
Cloneable {
    private static final long serialVersionUID = 611228437520889118L;
    private FbConnectionProperties properties;
    private Map<Integer, TransactionParameterBuffer> customMapping = new HashMap<Integer, TransactionParameterBuffer>();
    private FBTpbMapper mapper;

    public FBConnectionProperties() {
        this.properties = new FbConnectionProperties();
        this.properties.registerPropertyUpdateListener(this.createPropertyUpdateListener());
    }

    @Override
    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    @Override
    public void setProperty(String name, String value) {
        this.properties.setProperty(name, value);
    }

    @Override
    public Integer getIntProperty(String name) {
        return this.properties.getIntProperty(name);
    }

    @Override
    public void setIntProperty(String name, Integer value) {
        this.properties.setIntProperty(name, value);
    }

    @Override
    public Boolean getBooleanProperty(String name) {
        return this.properties.getBooleanProperty(name);
    }

    @Override
    public void setBooleanProperty(String name, Boolean value) {
        this.properties.setBooleanProperty(name, value);
    }

    @Override
    public Map<ConnectionProperty, Object> connectionPropertyValues() {
        return this.properties.connectionPropertyValues();
    }

    public int hashCode() {
        return Objects.hash(this.getType(), this.getServerName(), this.getPortNumber(), this.getDatabaseName());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FBConnectionProperties)) {
            return false;
        }
        FBConnectionProperties that = (FBConnectionProperties)obj;
        return this.properties.equals(that.properties) && this.customMapping.equals(that.customMapping) && (this.mapper == null || that.mapper == null || this.mapper.equals(that.mapper));
    }

    public Object clone() {
        try {
            FBConnectionProperties clone = (FBConnectionProperties)super.clone();
            clone.properties = (FbConnectionProperties)this.properties.asNewMutable();
            clone.properties.registerPropertyUpdateListener(clone.createPropertyUpdateListener());
            clone.customMapping = new HashMap<Integer, TransactionParameterBuffer>(this.customMapping);
            clone.mapper = this.mapper != null ? FBTpbMapper.copyOf(this.mapper) : null;
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError((Object)"Assertion failure: clone not supported");
        }
    }

    @Override
    public void setNonStandardProperty(String propertyMapping) {
        String value;
        String key;
        int equalsIndex = propertyMapping.indexOf(61);
        if (equalsIndex == -1) {
            key = propertyMapping.trim();
            value = "";
        } else {
            key = propertyMapping.substring(0, equalsIndex).trim();
            value = propertyMapping.substring(equalsIndex + 1).trim();
        }
        if (key.isEmpty()) {
            throw new IllegalArgumentException("Invalid non-standard property. Expected format: propertyName[=propertyValue], was: '" + propertyMapping + "'");
        }
        this.setProperty(key, value);
    }

    @Override
    public TransactionParameterBuffer getTransactionParameters(int isolation) {
        if (this.mapper != null) {
            return this.mapper.getMapping(isolation);
        }
        return this.customMapping.get(isolation);
    }

    @Override
    public void setTransactionParameters(int isolation, TransactionParameterBuffer tpb) {
        this.customMapping.put(isolation, tpb);
        if (this.mapper != null) {
            this.mapper.setMapping(isolation, tpb);
        }
    }

    public FBTpbMapper getMapper() throws SQLException {
        if (this.mapper != null) {
            return this.mapper;
        }
        String tpbMapping = this.getTpbMapping();
        this.mapper = tpbMapping == null ? FBTpbMapper.getDefaultMapper() : new FBTpbMapper(tpbMapping, this.getClass().getClassLoader());
        this.mapper.setDefaultTransactionIsolation(this.getDefaultTransactionIsolation());
        this.customMapping.forEach(this.mapper::setMapping);
        return this.mapper;
    }

    public IConnectionProperties asIConnectionProperties() {
        return this.properties;
    }

    private AbstractAttachProperties.PropertyUpdateListener createPropertyUpdateListener() {
        return new AbstractAttachProperties.PropertyUpdateListener(){

            @Override
            public void beforeUpdate(ConnectionProperty connectionProperty, Object newValue) {
                if ("tpbMapping".equals(connectionProperty.name()) && FBConnectionProperties.this.mapper != null) {
                    throw new IllegalStateException("Cannot update tpbMapping, properties are already initialized.");
                }
            }

            @Override
            public void afterUpdate(ConnectionProperty connectionProperty, Object newValue) {
                if ("defaultIsolation".equals(connectionProperty.name()) && FBConnectionProperties.this.mapper != null) {
                    FBConnectionProperties.this.mapper.setDefaultTransactionIsolation(FBConnectionProperties.this.getDefaultTransactionIsolation());
                }
            }
        };
    }
}

