/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.datasource;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import us.fatehi.utility.SQLRuntimeException;
import us.fatehi.utility.Utility;
import us.fatehi.utility.datasource.DatabaseConnectionSource;
import us.fatehi.utility.string.StringFormat;

abstract class AbstractDatabaseConnectionSource
implements DatabaseConnectionSource {
    private static final Logger LOGGER = Logger.getLogger(AbstractDatabaseConnectionSource.class.getName());
    protected Consumer<Connection> connectionInitializer;

    protected static Properties createConnectionProperties(String connectionUrl, Set<String> additionalDriverProperties, Map<String, String> connectionProperties, String user, String password) {
        Properties jdbcConnectionProperties;
        List<String> skipProperties = List.of("server", "host", "port", "database", "urlx", "user", "password", "url");
        try {
            Driver jdbcDriver = AbstractDatabaseConnectionSource.getJdbcDriver(connectionUrl);
            Set<String> jdbcDriverProperties = AbstractDatabaseConnectionSource.getJdbcDriverProperties(jdbcDriver, connectionUrl, additionalDriverProperties, skipProperties);
            jdbcConnectionProperties = new Properties();
            if (user != null) {
                jdbcConnectionProperties.setProperty("user", user);
            }
            if (password != null) {
                jdbcConnectionProperties.setProperty("password", password);
            }
            if (connectionProperties != null) {
                connectionProperties.remove("user");
                connectionProperties.remove("password");
                for (Map.Entry<String, String> connectionProperty : connectionProperties.entrySet()) {
                    String property = connectionProperty.getKey();
                    String value = connectionProperty.getValue();
                    if (jdbcDriverProperties.contains(property.toLowerCase()) && value != null) {
                        jdbcConnectionProperties.setProperty(property, value);
                        continue;
                    }
                    LOGGER.log(Level.CONFIG, new StringFormat("Skipping database connection property, <%s>=<%s>", property, value));
                }
            }
        }
        catch (SQLException e) {
            throw new SQLRuntimeException("Could not get connection properties", e);
        }
        return jdbcConnectionProperties;
    }

    protected static Connection getConnection(String connectionUrl, Properties jdbcConnectionProperties) {
        String user = jdbcConnectionProperties.getProperty("user");
        String username = user != null ? "user '%s'".formatted(user) : "unspecified user";
        try {
            LOGGER.log(Level.INFO, new StringFormat("Making connection to %s%nfor user '%s', with properties %s", connectionUrl, username, AbstractDatabaseConnectionSource.safeProperties(jdbcConnectionProperties)));
            Driver driver = AbstractDatabaseConnectionSource.getJdbcDriver(connectionUrl);
            Connection connection = driver.connect(connectionUrl, jdbcConnectionProperties);
            LOGGER.log(Level.INFO, new StringFormat("Opened database connection <%s>", connection));
            return connection;
        }
        catch (SQLException e) {
            throw new SQLRuntimeException("Could not connect to <%s>, for <%s>, with properties <%s>".formatted(connectionUrl, username, AbstractDatabaseConnectionSource.safeProperties(jdbcConnectionProperties)), e);
        }
    }

    private static Driver getJdbcDriver(String connectionUrl) throws SQLException {
        try {
            return DriverManager.getDriver(connectionUrl);
        }
        catch (SQLException e) {
            throw new SQLException("Could not find a suitable JDBC driver for database connection URL <%s>".formatted(connectionUrl), e);
        }
    }

    private static Set<String> getJdbcDriverProperties(Driver jdbcDriver, String connectionUrl, Set<String> additionalDriverProperties, List<String> skipProperties) throws SQLException {
        DriverPropertyInfo[] propertyInfo = jdbcDriver.getPropertyInfo(connectionUrl, new Properties());
        HashSet<String> jdbcDriverProperties = new HashSet<String>();
        for (DriverPropertyInfo driverPropertyInfo : propertyInfo) {
            String jdbcPropertyName = driverPropertyInfo.name;
            if (skipProperties != null && skipProperties.contains(jdbcPropertyName)) continue;
            jdbcDriverProperties.add(jdbcPropertyName.toLowerCase());
        }
        if (additionalDriverProperties != null) {
            additionalDriverProperties.stream().filter(property -> !Utility.isBlank(property)).map(property -> property.toLowerCase()).forEach(jdbcDriverProperties::add);
        }
        return jdbcDriverProperties;
    }

    private static Properties safeProperties(Properties properties) {
        Properties logProperties = new Properties(properties);
        logProperties.remove("password");
        return logProperties;
    }

    public AbstractDatabaseConnectionSource(Consumer<Connection> connectionInitializer) {
        this.connectionInitializer = Objects.requireNonNull(connectionInitializer, "No connection initializer provided");
    }

    @Override
    public void setFirstConnectionInitializer(Consumer<Connection> connectionInitializer) {
        if (connectionInitializer != null) {
            this.connectionInitializer = connectionInitializer.andThen(this.connectionInitializer);
        }
    }
}

